/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/inifiles.c 3.3 92/03/13 14:43:15 sbc Exp $
* $Log:	inifiles.c $
 * Revision 3.3  92/03/13  14:43:15  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 3.2  92/01/31  16:37:02  sbc
 * save and restore FCb around call to dos_sfirst().
 * 
 * 
 * Revision 3.1  91/08/19  16:40:23  system
 * ViewMAX 2 sources
 * 
 *	history
 *	03-Dec-91  K.H	Use dos_gdrv() and dos_gdir() instead of getdisk() and
 *			getcurdir().
 *	16-Oct-91  K.H	Add supporting double byte character set. (#if DBCS)
 *	16-May-91  RSF	Fix bug I added in check for comments.
 *	07-May-91  RSF	Add new write routines.
 *	06-May-91  RSF  Merged w/readini and renamed to inifiles.c.
 *	06-May-91  WHF  Fixed error return of ini_open_file
 *	29-Apr-91  WHF  Changed i/f to use FBYTE
 *	25-Apr-91  RSF	Cut all threads that go back to appslib.lib
 * 	05-Mar-91  EJH	Work began.
 */
#include <dir.h>

#include "shell.h"
#include "inidefs.h"
#include "viewapps.h"

/* MLOCAL char	ini_pathname[ INI_PATHNAME_LEN ] ; */
MLOCAL char	ini_section[  INI_SECTION_LEN  ] ;
MLOCAL char	ini_string[   INI_STRING_LEN   ] ;

extern GLOBES	G;

extern WORD	DOS_AX;
extern WORD	DOS_CX;
extern WORD	DOS_DX;
extern WORD	DOS_DS;
extern WORD	DOS_ERR;

#define CR	'\r'
#define LF	'\n'

/* The following two values must be recorded so we have a chance of
 * finding  a .INI when no DRDOSCFG has been set.
 */
GLOBAL WORD	gl_stdrv ;		/* drive we ran from */
char		start_path[ 65 ];	/* Path we ran from  */

/****************************************************************************
    This routine copies one file into another, starting at the current
    file pointers. Neither file is rewound.
****************************************************************************/
#define	TMP_BUFF_LEN	512
void CopyFile( WORD dstHndl, WORD srcHndl )
{
char		tmp[ TMP_BUFF_LEN ]		= {0} ;
WORD		len				= TMP_BUFF_LEN ;

    while ( len == TMP_BUFF_LEN ) {
	len = dos_read( srcHndl, TMP_BUFF_LEN, (long)(void far *)tmp ) ;
	dos_write( dstHndl, len, (long)(void far *)tmp ) ;
       }

    chsize( dstHndl, tell( dstHndl ) ) ;
    	
    dos_lseek( dstHndl, SEEK_SET, 0L ) ;
    dos_lseek( srcHndl, SEEK_SET, 0L ) ; 
    
} /* CopyFile() */

/****************************************************************************
*	This routine records the current drive and path for later use.
****************************************************************************/
void note_start_path( void )
{
    gl_stdrv = dos_gdrv();
    sprintf( start_path, "%c:\\", (char)(gl_stdrv+'A') ) ;
    dos_gdir( gl_stdrv+1, ADDR(&start_path[ strlen( start_path ) ]) );
	
#if DBCS
    if ( !isequalto(start_path, strlen( start_path ) - 1, '\\') )
#else /* DBCS */
    if ( start_path[ strlen( start_path ) - 1 ] != '\\' )
#endif /* DBCS */
	fstrcat( start_path, "\\" ) ;	/* make sure it ends with a '\' */
    
} /* note_start_path() */

/****************************************************************************
    fname comes in as "12345678.123" and goes out as "C:\FOO\12345678.123"
****************************************************************************/
BOOLEAN shel_find_ini( char far * fname )
{
FBYTE *	pEnv		= ( FBYTE * )0L ;
FBYTE * pEnvString ;
char	env_buff[256] ;
char	name_only[ LEN_ZFNAME ] ;
FCB	fcb ;
FCB far * pOldFCB ;
BOOLEAN ret ;
#if DBCS
WORD	i;
WORD	type = CT_ADE;
#endif /* DBCS */

    /* save original name */
    fstrcpy( (char far *)name_only, fname ) ;

    /* don't use ini_str() since we don't want to overwrite gl_lngstr[] */
    rsrc_gaddr( R_STRING, INIENV, (TREE *)&pEnvString );
    
    /* look for DRDOSCFG environment variable */
    shel_envrn( (LONG)(char far *)&pEnv, (LONG)pEnvString );
    
    if ( pEnv )	/* if defined */
       {
	fstrcpy( (char far *)env_buff, (char far *)pEnv );
	pEnv = (char far *)env_buff;
	if ( *pEnv == '=' ) pEnv++;
	fstrcpy( fname, (char far *)pEnv );    
       }
    else		/* use start_path (path we ran from) */
	fstrcpy( fname, (char far *)start_path );
    
#if DBCS
    for(i=0; fname[i]; i++)
	type = chkctype(fname[i], type);
    if ( fname[i-1] != '\\' || type != CT_ADE )
#else /* DBCS */
    if ( fname[ fstrlen( fname ) - 1 ] != '\\' )
#endif /* DBCS */
	fstrcat( fname, "\\" ) ;
    fstrcat( fname, (char far *)name_only );

    pOldFCB = dos_gdta() ;
    dos_sdta( (FCB far *)&fcb ) ;
    ret = dos_sfirst( fname, 0 ) ;	/* read/write */
    dos_sdta( pOldFCB ) ;
    
    return ret ;
    
} /* shel_find_ini() */

/* ***************************************************************************
 *	Returns offset of string to search for in file, relative to
 *	current file position. -1 if not found.
 ****************************************************************************/
#define TMP_SIZE	256
long find_offset( int fHandle, char * str )
{
char	tmp[ TMP_SIZE ] ;
char *	ptr ;
long	offset		= 0L ;
long	orig_pos	= 0L ;
WORD	bytes_read ;
WORD	len ;
BOOLEAN	found		= FALSE ;

    orig_pos = tell( fHandle ) ;		/* save original file pos */
    
    /* read in first buffer full to search through */
    bytes_read = dos_read( fHandle, TMP_SIZE-1, (long)(char far *)tmp ) ;
    tmp[ bytes_read ] = '\0' ;
    
    while ( !found && bytes_read != 0 ) {
	
	ptr = strstr( tmp, str ) ;
	if ( ptr != NULL ) {			/* found it */
	    found = TRUE ;
	    offset += (long)( ptr - tmp ) ;
	    dos_lseek( fHandle, SEEK_SET, orig_pos + offset ) ;
	    return offset ;
	}
	else {					/* not yet found */
	    /* look for end of last complete line */
	    ptr = strrchr( tmp, '\n' ) ;
	    if ( ptr == NULL ) return -1L ;	/* no crlf before eof */
	    
	    ++ptr ; /* advance to beginning of incomplete line */
	    offset += (long)( ptr-tmp ) ;
	    
	    len = strlen( ptr ) ;	/* len of partial line remaining */
	    memmove( (void *)tmp, (void *)ptr, len ) ;
	    bytes_read = dos_read( fHandle, TMP_SIZE-len-1, 
					    (long)(char far *)&tmp[ len ] ) ;
	    tmp[ bytes_read+len ] = '\0' ;
	}
    }
    
    return -1L ;	/* not found: EOF encountered */
	
} /* find_offset() */

/* ***************************************************************************
 *	Look for the section heading 
 *	Returns offset to first character of line following the [section]
 *	line, -1L if not found.
 ****************************************************************************/
long ini_section_offset( WORD fHndl, char * section )
{
char	tmp[ 256 ] ;
long	offset		= 0L ;

    dos_lseek( fHndl, SEEK_SET, 0L ) ;
    sprintf( tmp, "[%s]", section ) ;
    offset = find_offset( fHndl, tmp ) ;
    if ( offset == -1L )
	return -1L ;

    /* find ptr to beginning of next line */
    dos_lseek( fHndl, SEEK_SET, offset ) ;
    dos_read( fHndl, 256, (long)(void far *)tmp ) ;
    offset += (long)( strchr( tmp, '\n' ) + 1 - tmp ) ;
    dos_lseek( fHndl, SEEK_SET, offset ) ;
    return offset ;

} /* ini_section_offset() */

/****************************************************************************
*
*	Try to find the requested item within the newly found section.
*	Returns offset to first character following the 'item='.
*	Returns -1L if not found.
 ****************************************************************************/
long ini_item_offset( WORD fHndl, long offset, char * item )
{
char	tmp[ 256 ] ;
long	item_offset	= 0L ;
long	next_section	= 0L ;

    dos_lseek( fHndl, SEEK_SET, offset ) ;
    next_section = find_offset( fHndl, "[" ) ;

    sprintf( tmp, "%s=", item ) ;
    dos_lseek( fHndl, SEEK_SET, offset ) ;
    item_offset = find_offset( fHndl, tmp ) ;
    if ( item_offset == -1L )		/* not found */
	return -1L ;
    if ( next_section != -1L && item_offset > next_section ) 
	return -1L ;			/* found, but in another section */
    
    /* find ptr to first char past '=' */
    dos_lseek( fHndl, SEEK_SET, offset + item_offset ) ;
    dos_read( fHndl, 256, (long)(void far *)tmp ) ;
    item_offset += (long)( strchr( tmp, '=' ) + 1 - tmp ) ;
    dos_lseek( fHndl, SEEK_SET, offset + item_offset ) ;
    
    return( offset+item_offset ) ;
    
} /* ini_item_offset() */

/****************************************************************************
*	This routine writes a section heading into the ini file.  Open/Close 
*	and ordering of ini_write_section/ini_write_item calls are the
*	caller's responsibility.
****************************************************************************/
WORD ini_write_section( WORD fHndl, char * section )
{
char	tmp[ INI_SECTION_LEN ] ;
WORD	len ;

    sprintf( tmp, "[%s]%c%c", section, CR, LF ) ;
    len = strlen( tmp ) ;
    
    if ( len != dos_write( fHndl, len, (long)(void far *)tmp ) )
	return INI_SECTIONERR ;
    else
	return INI_SUCCESS ;

} /* ini_write_section() */
	
/****************************************************************************
*	This routine writes an item entry into the ini file.  Open/Close 
*	and ordering of ini_write_section/ini_write_item calls are the
*	caller's responsibility.
****************************************************************************/
WORD ini_write_item( WORD fHndl, char * item, char * string )
{
char	tmp[ INI_SECTION_LEN + INI_STRING_LEN ] ;
WORD	len ;

    sprintf( tmp, "%s=%s%c%c", item, string, CR, LF ) ;
    len = strlen( tmp ) ;
    
    if ( len != dos_write( fHndl, len, (long)(void far *)tmp ) )
	return INI_SECTIONERR ;
    else
	return INI_SUCCESS ;

} /* ini_write_item() */
	
/****************************************************************************
****************************************************************************/
WORD	ini_write( WORD fname_id, FBYTE *section, FBYTE *item,
				FBYTE *string )
{
WORD	fHndl ;
WORD	tfHndl ;
WORD	access ;
long	item_offset, section_offset ;
char	tmp[ MAX_LINE_LEN ] ;
char	tName[ INI_TEMPNAME_LEN ] ;
char	ini_item[ INI_SECTION_LEN ] ;

    fstrcpy( (char far *)ini_section, (char far *)section ) ;
    fstrcpy( (char far *)ini_string, (char far *)string ) ;
    fstrcpy( (char far *)ini_item, (char far *)item ) ;

    /* open VIEWMAX.INI */
    access = OPEN_FILE ;
    if ( fname_id == INIFNVM && G.g_exec )
	access |= TMP_FILE ;
    else if ( fname_id == INIFNTM )
	access |= CREATE_FILE ;
    fHndl = app_getfh_loop( access, fname_id, READWRITE, SPREFILE );
    if ( !fHndl )
	return INI_OPENERR ;
    
    /* app_getfh() leaves G.g_srcpth[] with full path and filename of .ini */
    strcpy( tName, G.g_srcpth ) ;
    *( 1 + strrchr( tName, '\\' ) ) = '\0' ;
    
    section_offset = ini_section_offset( fHndl, ini_section );
    if ( section_offset == -1L ) {
	/* didn't find section name so create a new section at	*/
	/* the end of the file.					*/
	dos_lseek( fHndl, SEEK_END, 0L ) ;
	
	ini_write_section( fHndl, ini_section );
	ini_write_item( fHndl, ini_item, ini_string );
	
	dos_close( fHndl ) ;
	return INI_SUCCESS ;
    }

    /* copy original INI file into temp file. */
    tfHndl = creattemp( tName, 0 ) ;
    dos_lseek( fHndl, SEEK_SET, 0L ) ;
    CopyFile( tfHndl, fHndl ) ;
    
    /* We have found the section heading, now we must look for the	*/
    /* required item.						*/

    item_offset = ini_item_offset( tfHndl, section_offset, ini_item );

    if ( item_offset == -1L ) { 	/* We didn't find the item name */
	/* get both files lined up together */
	dos_lseek( fHndl, SEEK_SET, section_offset );
	dos_lseek( tfHndl, SEEK_SET, section_offset );

	/* write new "item=string" line to file */
	sprintf( tmp, "%s=%s%c%c", ini_item, ini_string, CR, LF ) ;
	dos_write( fHndl, strlen( tmp ), (long)(void far *)tmp ) ;
    }	
    else {				/* We did find the item name */
	/* get both files lined up together */
	chsize( fHndl, item_offset ) ;
	dos_lseek( fHndl, SEEK_END, 0L );
	dos_lseek( tfHndl, SEEK_SET, item_offset );

	/* write new end for "item=string" line */
	sprintf( tmp, "%s%c%c", ini_string, CR, LF ) ;
	dos_write( fHndl, strlen( tmp ), (long)(void far *)tmp ) ;

	/* advance original past previous value for "string" */
	dos_lseek( tfHndl, SEEK_SET,
	    item_offset + find_offset( tfHndl, "\n" ) + strlen( "\n" ) ) ;
    }	

    /* copy the rest of the original file */
    CopyFile( fHndl, tfHndl ) ;

    /* clean up */
    dos_close( fHndl ) ;
    dos_close( tfHndl ) ;
    dos_delete( (long)(char far *)tName ) ;
	
    return( INI_SUCCESS );
	
} /* ini_write() */

/***************************************************************************
*	This routine will open the ini file and read out a single item,
*	closing the file when it is done.
***************************************************************************/
WORD	ini_read( WORD fname_id, FBYTE *section, FBYTE *item,
			       FBYTE *buffer, WORD size )
{
WORD	fHndl ;
long	item_offset, section_offset ;
char	ini_item[ INI_SECTION_LEN ] ;

    fstrcpy( (char far *)ini_section, (char far *)section ) ;
    fstrcpy( (char far *)ini_item, (char far *)item ) ;

    /* open VIEWMAX.INI */
    fHndl = app_getfh_loop( OPEN_FILE, fname_id, READONLY, SPREFILE ) ;
    if ( !fHndl )
	return INI_OPENERR ;
		
    /* Look for the section heading */
    section_offset = ini_section_offset( fHndl, ini_section );

    if ( section_offset == -1L ) {
	dos_close( fHndl );
	return( INI_SECTIONERR );
    }
	
    /* We have found the section heading, now we must look for the	*/
    /* required item.						*/

    item_offset = ini_item_offset( fHndl, section_offset, ini_item );

    if ( item_offset == -1L ) {		/* We didn't find the item */
	dos_close( fHndl );
	return( INI_ITEMERR );
    }

    /* read the string from "item=string" in the file, copy to buffer */
    dos_lseek( fHndl, SEEK_SET, item_offset ) ;

    dos_read( fHndl, INI_STRING_LEN, (long)(char far *)ini_string ) ;
    *strchr( ini_string, '\r' ) = NULL ;

    fmemcpy( (void far *)buffer, (void far *)&ini_string, size ) ;
    
    dos_close( fHndl );

    return( INI_SUCCESS );
	
} /* ini_read() */

/* end of inifiles.c */


