/*	LISTBOX.C		06/21/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    Copyright (c) 1988,1992 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/* 891206 DLB #41: Add redraw flag to dsel_rbut.			    */
/*
 * 891128 rs added considering of hidden items in lb_scroll()
 * 900329 ts split off from EXOBINIT.C
 */

/*--------------------------------------------------------------------------
Date	Who	Spr	Comments
----	---	---	--------
910502	RSF		Warning removal.
910426	RSF		Color categories.
910404	RSF		Fix bugs caused by LONG  being unsigned.
910325	RSF		Adapt for use in ViewMAX.
*/

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "danutil.h"
#include "exproto.h"

/*--------------------------------------------------------------------------*/
/* NAME: slot_num							    */
/*									    */
/* PURPOSE: Set the slot number string.					    */
/*--------------------------------------------------------------------------*/
MLOCAL    VOID
slot_num( TREE	    tree,
	  WORD	    slot_obj,
	  WORD	    slot_num
	  )
{
    FBYTE	*num_str;
    WORD	num_obj;
    BYTE	buf[80], *dot_ptr, *buf_ptr;
    BYTE	num[80], *num_ptr;
    
    num_obj = find_exobj( tree, slot_obj, LB_NUMBER );
    num_str = get_rscstr( tree, num_obj );
    fstrcpy( (char far *)buf, num_str );
    
    dot_ptr = strrchr( buf, '.' );
    if( !dot_ptr )
	dot_ptr = buf + strlen( buf );
    
#if 0
    i_to_a( slot_num+1, num );
#endif
    litoa( (SLONG)slot_num+1, num);
    num_ptr = dot_ptr - strlen( num );
    
    for( buf_ptr = buf; buf_ptr < num_ptr; buf_ptr++ )
	*buf_ptr = ' ';
    
    for( num_ptr = num; *num_ptr; num_ptr++ )
	*buf_ptr++ = *num_ptr;
    
    fstrcpy( num_str, (char far *)buf );
}

/*--------------------------------------------------------------------------*/
/* NAME: set_slot							    */
/*									    */
/* PURPOSE: Sets the pointer for the given slot object to the given item.   */
/*									    */
/* INPUT:   FDOBJECT	*slot_ptr-  Pointer to slot object.		    */
/*	    FBYTE	*it_ptr	-   Pointer to item in list.		    */
/*									    */
/* OUTPUT:  none.							    */
/*									    */
/*--------------------------------------------------------------------------*/
    MLOCAL VOID
set_slot(     TREE	tree,
	      WORD	slot_obj,
	      FBYTE	*it_ptr,
	      WORD	it_num
	      )
{
    FDOBJECT	*slot_ptr;
    FTEDINFO	*tinfo;			/* Pointer to TEDINFO .		    */
    
    slot_ptr = tree + slot_obj;
    if( slot_ptr->ob_head >= 0 )
    {
	slot_num( tree, slot_obj, it_num );
	slot_obj = find_exobj( tree, slot_obj, LB_LABEL );
	slot_ptr = tree + slot_obj;
    }
    
    switch( slot_ptr->ob_type & 0x00FF )
    {
	case G_TEXT:
	case G_BOXTEXT:
	case G_FTEXT:
	case G_FBOXTEXT:
	    tinfo = (FTEDINFO *)(slot_ptr->ob_spec);
	    tinfo->te_ptext = it_ptr;
	    break;
	case G_BUTTON:
	case G_STRING:
	case G_TITLE:
	    slot_ptr->ob_spec = it_ptr;
	    break;
	default:
	    slot_ptr->ob_spec = it_ptr;
	    break;
    }
}

/*--------------------------------------------------------------------------*/
/* NAME:    lb_scroll()							    */
/*									    */
/* PURPOSE: This routine handles moving the 'dragged' scroll box.	    */
/*									    */
/*--------------------------------------------------------------------------*/
/*
 * 891128 rs added considering of hidden items
 */
    GLOBAL VOID
lb_scroll( 
	   FBYTE	*ldata,		/* List box data.		    */
	   SLONG	new_start,	/* New first item in list box.	    */
	   WORD		redraw		/* Redraw flag.			    */
	 )
{
    FLISTBOX	*lb;			/* Pointer to listbox data.	    */

    FLISTITEM	*item;			/* Pointer to item in list.	    */
    WORD	slot;			/* Object number for current slot.  */
    WORD	slots;			/* Object number of slots parent.   */
    WORD	count;			/* Slot counter.		    */
    FDOBJECT	*slot_ptr;		/* Pointer to current slot object.  */
    RECT	r;			/* Redraw clip.			    */
    WORD	item_num;
		
    lb = (FLISTBOX *)ldata;

    if( new_start != lb->lb_sld.sld_val )
    {
	lb->lb_sld.sld_val = new_start;
	lb->strt_item = (WORD)lb->lb_sld.sld_val;
	lb->ptr_strt_item = get_item( lb->items->start, lb->strt_item, TRUE , TRUE);
	
	count = lb->num_slots;
	item = lb->ptr_strt_item;
	item_num = lb->strt_item;
	slots = find_exobj( lb->lb_sld.sld_exob.exob_tree,
			    lb->lb_sld.sld_exob.exob_obj, LB_SLOTS );
	slot_ptr = lb->lb_sld.sld_exob.exob_tree + slots;
	for( slot = slot_ptr->ob_head; slot != slots;
	     slot = slot_ptr->ob_next )
	{
/*
 * if this is a hidden item, go for the next unhidden one up to the end of list
 * you can't use ls_skiphidden because even the first one could be a hidden one
 */
            while (item && (item->flags & HIDETREE))
            {
               item = item->next;
            }
	    if( item == (FLISTITEM *) 0L || !count )
		break;
	    slot_ptr = lb->lb_sld.sld_exob.exob_tree + slot;
	    set_slot( lb->lb_sld.sld_exob.exob_tree, slot, 
		      item->it_ptr, item_num );
	    updState_exobj( lb->lb_sld.sld_exob.exob_tree, slot, item->state,
			    SET, FALSE );
	    slot_ptr->ob_flags = item->flags | lb->dflt_flags;
	    item = item->next;
	    item_num++;
	    count--;
	}
	
	while( count-- )
	{
	    slot_ptr = lb->lb_sld.sld_exob.exob_tree + slot;
	    slot_ptr->ob_flags |= HIDETREE;
	    slot = slot_ptr->ob_next;
	}
	
	if( redraw )
	{
	    get_obloc( lb->lb_sld.sld_exob.exob_tree, slots, &r );
	    objc_draw( lb->lb_sld.sld_exob.exob_tree, slots, MAX_DEPTH,
		    r.x, r.y, r.w, r.h );
	}
    }
} /* lb_scroll */

/*--------------------------------------------------------------------------*/
/* NAME: lb_init							    */
/*									    */
/* PURPOSE: Initializes the list box. This routine assumes that the list    */
/*	    associated with the list box is already in place.		    */
/*									    */
/* INPUT:   FLISTBOX	*lb	-   List box data.			    */
/*									    */
/* OUTPUT:  FLISTBOX	*lb	-   List box data with updated slider data. */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
lb_init( TREE		tree,
	 WORD		obj,
	 WORD		redraw
	 )
{
    FLISTBOX	*lb;			/* Pointer to list box data.	    */
    WORD	area;			/* Object number of the area.	    */
    WORD	knob;			/* Object number for knob.	    */
    FDOBJECT	*area_ptr;		/* Pointer to area object.	    */
    FDOBJECT	*knob_ptr;		/* Pointer to knob object.	    */
    FDOBJECT	*arrow_ptr;		/* Pointer to arrow objects.	    */
    SLONG	step[3];		/* Nice step values.		    */
    WORD	hgt;			/* Height Of area - height of knob. */
    WORD	not_seen;		/* Number of items not seen in box. */
    SLONG	val;			/* Initial value.		    */
    SLONG	slct;			/* Nimber of selected item.	    */
    RECT	r;
    WORD	count;
    
    lb = (FLISTBOX *)get_data_ptr( tree, obj );
    
    area = find_exobj( lb->lb_sld.sld_exob.exob_tree,
		       lb->lb_sld.sld_exob.exob_obj, SLD_AREA );
    knob = find_exobj( lb->lb_sld.sld_exob.exob_tree,
		       lb->lb_sld.sld_exob.exob_obj, SLD_KNOB );
    area_ptr = lb->lb_sld.sld_exob.exob_tree + area;
    set_3d_color(area_ptr, CC_SLIDER);
    knob_ptr = lb->lb_sld.sld_exob.exob_tree + knob;
				    /* Give 3-D effects to scroll bars */
				    /* and the button color category   */
    set_3d_color(knob_ptr, CC_BUTTON);
    arrow_ptr = lb->lb_sld.sld_exob.exob_tree + find_exobj( 
		    lb->lb_sld.sld_exob.exob_tree,
		    lb->lb_sld.sld_exob.exob_obj, SLD_UP);
    set_3d_color(arrow_ptr, CC_BUTTON);
    arrow_ptr = lb->lb_sld.sld_exob.exob_tree + find_exobj( lb->lb_sld.sld_exob.exob_tree,
		    lb->lb_sld.sld_exob.exob_obj, SLD_DOWN);
    set_3d_color(arrow_ptr, CC_BUTTON);
    
    count = ls_count( lb->items->start, lb->items->end, TRUE, FALSE );
/*** RSF: changed LMUL_DIV to umul_div ***/
    knob_ptr->ob_box.h = umul_div( area_ptr->ob_box.h, lb->num_slots,
				  max(count, lb->num_slots) );

    not_seen = max(count - lb->num_slots, 0);
    lb->lb_sld.sld_min = 0;
    lb->lb_sld.sld_max = not_seen;
    lb->lb_sld.sld_minor = 1;
    lb->lb_sld.sld_major = lb->num_slots;
    
    step[0] = 10L;
    hgt = area_ptr->ob_box.h - knob_ptr->ob_box.h;
    if( hgt & not_seen )
	step[1] = (SLONG)(((not_seen + hgt - 1) / hgt ) * 10 );
    else
	step[1] = 0L;
    step[2] = 0L;
    set_strans( &lb->lb_sld, step );
    
    val = lb->strt_item;
    slct = lst_selected( lb->items );
    if( slct >= 0 )
    {	/*lst_selected does not skip hidden so in get_item, last param shall
    	  be FALSE. 900605 -mlc*/
	lb->items->cur =get_item(lb->items->start, (WORD)slct, 
		TRUE, FALSE/*TRUE*/);
	if( slct < val || slct >= val + lb->num_slots )
	{
	    val = slct - (lb->num_slots / 2);
	}
    }
    else if( lb->lb_options & LB_DEFAULT_TOP )
    {
	lb->items->cur = lb->items->start;
	val = 0;
	lb->items->cur->state |= SELECTED;
    }
    else
	lb->items->cur = (FLISTITEM *)0L;
    
    val = (SLONG)mid( 0, (WORD)val, not_seen );
    lb->lb_sld.sld_val = -1;
    lb->lb_sld.sld_func = lb_scroll;
    lb_scroll( (FBYTE *)lb, val, redraw );
    snap_knob( &lb->lb_sld, FALSE );
    if( redraw )
    {
	get_obloc( lb->lb_sld.sld_exob.exob_tree, area, &r );
	objc_draw( lb->lb_sld.sld_exob.exob_tree, area, MAX_DEPTH, 
		r.x, r.y, r.w, r.h );
    }
}

#if 0
MLOCAL    VOID
lb_setup( TREE	    tree,
	  WORD	    obj,
	  FLIST	    *ls,
	  WORD	    options,
	  WORD	    redraw
	  )
{
    FLISTBOX	*lb;			/* Pointer to list box data.	    */

    lb = (FLISTBOX *)get_data_ptr( tree, obj );
    
    lb->items = ls;
    lb->lb_options = options;
    
    lb_init( tree, obj, redraw );
}

MLOCAL    FLIST
*lb_list( TREE	    tree,
	  WORD	    obj
	  )
{
    FLISTBOX	*lb;
    
    lb = (FLISTBOX *)get_data_ptr( tree, obj );
    return( lb->items );
}
#endif
