/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1992  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/memyman.c 4.4 92/03/26 14:43:21 sbc Exp $
* $Log:	memyman.c $
 * Revision 4.4  92/03/26  14:43:21  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.3  92/02/19  14:01:55  sbc
 * include dos.h and do away with local define of MK_FP().
 * 
 * Revision 4.2  92/02/03  14:47:13  sbc
 * check for ems_hndl == 0 in Free_memory().
 * 
 * Revision 4.1  91/11/08  12:45:31  anderson
 * Rudimentary centralized memory manager.  Tries to use 4 16K pages, no page
 * mapping yet.
 * 
*****************************************************************************/

/****************************************************************************
* File:		memyman.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/

#include <dos.h>
#include "shell.h"

/****************************************************************
 *  EMS.C contains:
 *  Centralized memory manager routines that govern all dynamic
 *  allocations from both conventional and EMS memory.
 ****************************************************************/
     
GLOBAL	BYTE	ems_ok;
GLOBAL	BYTE	emm_vers;
GLOBAL	WORD	pf_seg;
GLOBAL	WORD	ppgs;
GLOBAL	WORD	lpgs;
GLOBAL	WORD	ems_hndl;

BOOLEAN	Get_Memory(WORD size, void far **memptr)
{
    BYTE	page;
    
    if ((ems_ok = EMS_Init(&emm_vers, &pf_seg, &ppgs, &lpgs)) == FALSE)
	return(FALSE);
    
    if ((ppgs < 4) || (lpgs < 4))
	return(FALSE);
    
    if ((ems_hndl = EMS_Alloc(4)) == FALSE)
	return(FALSE);

    for (page = 0; page < 4; page++)
    {
	if (EMS_Map(ems_hndl, page, page) == FALSE)
	    return(FALSE);
    }
    
    *memptr = MK_FP(pf_seg, 0);
    return(TRUE);
    
} /* end Get_Memory() */
    
    
/****************************************************************
 *
 ****************************************************************/
void	Free_Memory(void)
{
    if ( ems_hndl != 0 )
	EMS_Free( ems_hndl );
}



/*
 *	EOF:	memyman.c
 */
