/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/proto.h 4.24 92/04/10 13:39:06 sbc Exp $
* $Log:	proto.h $
 * Revision 4.24  92/04/10  13:39:06  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.23  92/04/09  14:54:43  sbc
 * Merge Becky's memory management improvements re backgrounds
 * 
 * Revision 4.22  92/04/06  09:43:29  Fontes
 * Initial cut to extract/display Windows exe embedded icons. Asm optimizations for bitmaps
 * 
 * Revision 4.21  92/04/03  17:13:28  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.20  92/03/26  14:45:57  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.19  92/03/13  14:44:09  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.18  92/03/12  13:54:22  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.17  92/03/05  09:29:47  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.16  92/02/27  15:31:33  rsf
 * Communication and display of chosen background image
 * 
 * Revision 4.15  92/02/27  09:40:32  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.14  92/02/25  08:13:05  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.13  92/02/19  15:58:28  sbc
 * remove proto for app_blddsk() (now local to deskinit.c)
 * 
 * Revision 4.12  92/02/18  16:05:37  sbc
 * add params to NewProgramItem().
 * 
 * Revision 4.11  92/02/06  15:48:03  sbc
 * add proto for new function in deskinit.c: cleanup().
 * 
 * Revision 4.10  92/02/06  12:09:48  sbc
 * add new procedure unload_bmp()
 * 
 * Revision 4.9  92/02/05  17:57:49  anderson
 * Tree routine changes.  Also put extract() prototype back in...it is and was
 * used by desktree.
 * 
 * Revision 4.8  92/02/05  13:56:15  sbc
 * add protos for functions in new module DESKPGRP.C
 * 
 * Revision 4.7  92/02/04  16:16:51  sbc
 * add protos fro memyman.c
 * replace protos for desktop.c with protos for deskmain.c and deskinit.c
 * 
 * Revision 4.6  92/01/31  16:33:50  sbc
 * change params for dos_sdta(), dos_gdta() and dos_sfirst() to
 * take far FCB and far char.
 * 
 * Revision 4.5  92/01/28  14:59:48  rsf
 * *** empty log message ***
 * 
 * Revision 4.5  92/01/21  13:33:59  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.4  92/01/06  13:18:18  anderson
 * Color icon work from Becky.
 * 
 * Revision 4.3  91/12/20  13:39:51  anderson
 * Converted TNODEs to FNODEs, deleted several tree handling routines and
 * added one of same.  Plus misc. other mods.
 * 
 * Revision 4.2  91/11/08  10:07:10  anderson
 * Moveable-sizeable windows changes.
 * 
 * Revision 4.1  91/09/17  13:57:33  system
 * Initial work for DOS window, screen saver, etc.
 * 
 * Revision 3.1  91/08/19  16:31:27  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911128	K.H		Add prototype for FSAFMT.
910606	RSF		New parm to win_vistop.
910522	RSF		Change C-E tree routine prototypes.
910520	RSF		Add ce_tree, vqt_attributes.
910516	RSF		Change pro_run
910506	RSF		Prototype for check_for_taskmax().
910502	RSF		Prototype for color pref calls.
910425	RSF		Prototypes for taskmax.
910417	HCA		Prototype for movsfar
910416	RSF		Modify tm_status parms.
910415	RSF		TaskMAX API calls.
910410	WHF		prototype for color prefs
910321	RSF		Additional vdi calls.
*****************************************************************************/
#ifndef PROTO_INCLUDED
#define PROTO_INCLUDED

/* deskact.c 	--------------------------------------------------------*/ 
  
extern  WORD gr_obfind( TREE tree, WORD root, WORD mx, WORD my );
extern  WORD gr_isdown( WORD out, WORD x, WORD y, WORD w, WORD h, UWORD *pmx, 
		UWORD *pmy, UWORD *pbutton, UWORD *pkstate );
extern  void gr_accobs( TREE tree, WORD root, WORD *pnum, WORD *pxypts );
extern  void gr_plns( WORD x, WORD y, WORD numpts, WORD *xylnpts, WORD numobs, WORD *xyobpts );
extern  WORD gr_bwait( GRECT *po, WORD mx, WORD my, WORD numpts, WORD *xylnpts, 
		WORD numobs, WORD *xyobpts );
extern  void gr_drgplns( WORD in_mx, WORD in_my, GRECT *pc, WORD *pdulx, 
		WORD *pduly, WORD *pdwh, WORD *pdobj );
extern  WORD bit_on( WORD x, WORD y, ULONG praster, WORD bwidth );
extern  WORD act_chkobj( TREE tree, WORD root, WORD obj, WORD mx, WORD my, WORD w, WORD h );
extern  WORD act_chg( WORD wh, TREE tree, WORD root, WORD obj, GRECT *pc, 
		UWORD chgvalue, WORD dochg, WORD dodraw, WORD chkdisabled );
extern  void act_allchg( WORD wh, TREE tree, WORD root, WORD ex_obj, GRECT *pt, 
		GRECT *pc, WORD chgvalue, WORD dochg, WORD dodraw );
extern  WORD act_bsclick( WORD wh, TREE tree, WORD root, WORD mx, WORD my, 
		WORD keystate, GRECT *pc, WORD dclick, WORD chktag );
extern  WORD act_bdown( WORD wh, TREE tree, WORD root, WORD *in_mx, 
		WORD *in_my, WORD keystate, GRECT *pc, WORD *pdobj );


/* deskapp.c 	--------------------------------------------------------*/ 
  
extern  char * string_alloc( char far * string );
extern  WORD app_getfh( WORD openit, WORD string_num, WORD attr );
extern  WORD app_getfh_loop( WORD openit, WORD string_num, WORD attr, 
							    WORD err_id );
extern  ANODE *app_alloc( WORD tohead );
extern  void app_free( ANODE *pa );
extern  INODE * inode_alloc( BOOLEAN tohead );
extern  void inode_free( INODE * pi );
extern  BYTE *scan_str( BYTE *pcurr, BYTE * *ppstr );
extern  void app_tran( WORD bi_num );
extern  WORD app_start( void );
extern  void app_save( void );
extern  ANODE *find_anode( FNODE far * pf );

/* deskbkgd.c 	--------------------------------------------------------*/

extern  void    unload_bmp( FDB far * pFDB );
extern	FDB far *load_bmp_file( char *fname, BOOLEAN dump_g_bitmap );
extern	void	render_bmp( FDB far* fdb, WORD x, WORD y );
extern	BOOLEAN	choose_bkgd( WORD * new_type, BYTE * new_name );

/* deskcet.c 	--------------------------------------------------------*/

extern	void ce_tree( 	WORD which, 	/* Whether to collapse or expand */
			WORD wh, 	/* Current window		 */
			TREE tree, 	/* Tree for window objects	 */
			WORD root, 	/* Root object of window	 */
			WORD mx, 	/* X-coord of click or KS	 */
			WORD my, 	/* Y-coord of click or KS	 */
			WORD dclick );	/* True if should mimic dbl click*/

extern	FNODE far *cet_clicked_tag( 
		WORD	wh, 		/* Current window		 */
		WORD	obj, 		/* Clicked object		 */
		TREE    tree, 		/* Tree for window objects	 */
		WORD	root, 		/* Root object of window	 */
		WORD    mx );		/* X-coord of click or KS	 */

extern	void cet_act_tag( 
		WORD wh, 		/* Handle of current window	*/
		FNODE far *parent, 	/* Dir whose tag was changed.	*/
		WORD dclick );		/* True of double-clicked	*/


/* deskcicn.c 	--------------------------------------------------------*/

extern	void init_icon( ICONBLK far *icon, WORD index );
extern	void convert_bmp_fdb( WORD fh, WORD bit_count, WORD width, 
		WORD height, WORD far *planes, LONG pl_size, 
		BOOLEAN read_mask );
extern	BOOLEAN load_ico_file( WORD fh, CICON *cicon );
extern	BOOLEAN load_ico_from_exe(BYTE *fname, CICON *cicon);

/* deskclrs.c 	--------------------------------------------------------*/

extern	void color_prefs( void );
extern	void cs_init_colors( void );
extern	void cs_save_curr_color( void );


/* deskdir.c 	--------------------------------------------------------*/ 
  
extern  void draw_dial( TREE tree );
extern  void show_hide( WORD fmd, TREE tree );
extern  void draw_fld( TREE tree, WORD obj );
extern  BYTE *scan_slsh( BYTE *path );
extern  void add_fname( BYTE *path, BYTE *new_name );
extern  void del_fname( BYTE far * pstr );
extern  void get_fname( BYTE *pstr, BYTE *newstr );
extern  WORD d_errmsg( void );
extern  WORD d_dofdel( BYTE *ppath );
extern  WORD d_dofcopy( BYTE *psrc_file, BYTE *pdst_file, WORD time, WORD date, WORD attr );
extern  WORD d_doop( WORD op, TREE tree, WORD obj, BYTE *psrc_path, 
		BYTE *pdst_path, WORD *pfcnt, WORD *pdcnt, WORD flag );
extern  BYTE *ret_path( BYTE *pcurr );
extern  WORD par_chk( BYTE far *psrc_path, FNODE far *pflist, BYTE *pdst_path );
extern  WORD dir_op( WORD op, BYTE far *psrc_path, FNODE far *pflist, BYTE *pdst_path, 
		WORD *pfcnt, WORD *pdcnt, ULONG *psize, WORD dulx, WORD duly, 
		WORD from_disk, WORD src_ob );
extern  void blank_it( WORD obid );
extern  void move_icon( WORD obj, WORD dulx, WORD duly );


/* deskfpd.c 	--------------------------------------------------------*/ 
  
extern  void fn_init( void );
extern  void pn_init( void );
extern  BOOLEAN fpd_start( void );
extern  WORD fpd_bldspec( WORD drive, BYTE * ppath, BYTE * pname, BYTE * pext, 
							BYTE far * pspec );
extern  void fpd_parse( BYTE far * pspec, 
			    WORD * pdrv, BYTE * ppath, BYTE * pname, BYTE * pext );
extern  FNODE far *fpd_ofind( FNODE far *pf, WORD obj );
extern  void fn_free( FNODE far *thefile );
extern  void fl_free( FNODE far *pflist );
extern  FNODE far * fn_alloc( void );
extern  PNODE far * pn_alloc( void );
extern  void pn_free( PNODE far * thepath );
extern  void pn_close( PNODE far * thepath );
extern  PNODE far * pn_open( WORD drive, BYTE *path, BYTE *name, BYTE *ext );
extern  WORD pn_fcomp( FNODE far *pf1, FNODE far *pf2, WORD which );
extern  WORD pn_comp( FNODE far *pf1, FNODE far *pf2 );
extern  FNODE far *pn_sort( WORD lstcnt, FNODE far *pflist );
extern  WORD pn_folder( WNODE far * pw );
extern  WORD pn_desktop( PNODE far * thepath );
extern  WORD pn_active( WNODE far * pw );
extern  WORD GetIcon( FNODE far * pf, ANODE * pa );


/* deskfun.c 	--------------------------------------------------------*/ 
  
extern  BYTE * rsc_get_string( WORD fHndl, WORD string_num );
extern  WORD alert( WORD defbut, WORD stnum );
extern  WORD alert_s( WORD defbut, WORD stnum, BYTE * s );
extern	WORD in_mem_alert_s( WORD defbut, WORD alert_num, BYTE * s );
extern  WORD alert_sd( WORD defbut, WORD stnum, BYTE * s, WORD d );
extern  void fun_msg( WORD type, WORD w3, WORD w4, WORD w5, WORD w6, WORD w7 );
extern	void rebld_one_win( WNODE far *pwin );
extern  void fun_rebld( WNODE far *pwin );
extern  WORD fun_mkdir( WNODE far *pw_node );
extern  WORD fun_op( WORD op, PNODE far * pspath, BYTE *pdest, WORD dulx, WORD duly, 
		WORD from_disk, WORD src_ob );
extern  WORD fun_wdst( PNODE far * pspath, BYTE far * pdspec, WORD datype, FNODE far *pdf, 
		WORD dulx, WORD duly, WORD from_disk, WORD src_ob );
extern  WORD fun_disk( WORD src_ob, WNODE far *pdw, WORD datype, FNODE far *pdf, WORD dulx, WORD duly );
extern  void fun_drag( WORD src_wh, WORD dst_wh, WORD dst_ob, WORD dulx, WORD duly );
extern  void fun_del( WNODE far *pdw );
extern  WORD cmp_names( BYTE *psrc, BYTE *pdst );
#if HELP_ALERTS
extern  void do_help_alert( short alert_num ) ;
#endif /* HELP_ALERTS */


/* deskgraf.c 	--------------------------------------------------------*/ 
  
extern  WORD gsx_sclip( GRECT *pt );
extern  void gsx_gclip( GRECT *pt );
extern  WORD gsx_xline( WORD ptscount, WORD *ppoWORDs );
extern  WORD gsx_pline( WORD offx, WORD offy, WORD cnt, WORD *pts );
extern  void gsx_attr( UWORD text, UWORD mode, UWORD color );
extern  void gsx_fix( FDB *pfd, ULONG theaddr, WORD wb, WORD h );
extern  void gsx_blt( ULONG saddr, UWORD sx, UWORD sy, UWORD swb, ULONG daddr, 
		UWORD dx, UWORD dy, UWORD dwb, UWORD w, UWORD h, UWORD rule, 
		WORD fgcolor, WORD bgcolor );
extern  void bb_screen( WORD scrule, WORD scsx, WORD scsy, WORD scdx, WORD scdy, 
		WORD scw, WORD sch );
extern  void gsx_trans( ULONG saddr, UWORD swb, ULONG daddr, UWORD dwb, UWORD h );
extern  void gsx_start( void );
extern  void gsx_tblt( WORD tb_f, WORD x, WORD y, WORD tb_nc );
extern  void bb_fill( WORD mode, WORD fis, WORD patt, WORD hx, WORD hy, WORD hw, WORD hh );
extern	void gsx_bxpts( GRECT *pt );
extern	void gsx_box( GRECT *pt );
extern	void gr_inside( GRECT *pt, WORD th );
extern	void gr_box( WORD x, WORD y, WORD w, WORD h, WORD th );
extern	void set_mfdb( FDB *mf, BYTE far *image, WORD width, WORD hgt, 
		WORD ff, WORD np );


/* deskgsx.c 	--------------------------------------------------------*/ 
  
extern  void gsx_1code( WORD code, WORD value );
extern  void gsx_ncode( WORD code, WORD n, WORD m );
extern  void gsx_vclose( void );
extern  void gsx_vopen( void );

extern  void v_gtext( WORD, WORD, BYTE * );
extern  void v_opnvwk( WORD *pwork_in, WORD *phandle, WORD *pwork_out );
extern  void v_pline( WORD count, WORD *pxyarray );
extern  void vr_recfl( WORD *pxyarray, WORD *pdesMFDB );
extern  void vrn_trnfm( WORD *psrcMFDB, WORD *pdesMFDB );
extern  void vro_cpyfm( WORD wr_mode, WORD *pxyarray, WORD *psrcMFDB, WORD *pdesMFDB );
extern  void vrt_cpyfm( WORD wr_mode, WORD *pxyarray, WORD *psrcMFDB, 
		WORD *pdesMFDB, WORD fgcolor, WORD bgcolor );
extern  void vq_extnd( WORD owflag, WORD *work_out );
extern	void vqt_attributes( WORD *attributes );
extern  WORD vs_clip( WORD clip_flag, WORD *pxyarray );
extern  void vsl_color( WORD color_index );
extern	void vsl_ends( WORD beg_style, WORD end_style );
extern	void vsl_type( WORD type );
extern  void vsl_width( WORD width );
extern  void vst_alignment( WORD, WORD, WORD *, WORD * );
extern  void vst_font( WORD );
extern  void vst_height( WORD height, WORD *pchr_width, WORD *pchr_height, 
		WORD *pcell_width, WORD *pcell_height );
extern	void vswr_mode( WORD mode );


/* deskif.c 	--------------------------------------------------------*/ 
  
extern  void gsx_moff( void );
extern  void gsx_mon( void );


/* deskinf.c 	--------------------------------------------------------*/ 
  
#if DBCS 
extern	void cvt_dbc2( UBYTE * soffs, UBYTE * coffs );
#endif /* DBCS */
extern  WORD dr_code( PARMBLK far * pparms ) ;
#if HELP_ALERTS
extern  WORD inf_show( TREE tree, WORD start, WORD help_alert, 
		BOOLEAN end_draw );
#else /* HELP_ALERTS */
extern  WORD inf_show( TREE tree, WORD start, BOOLEAN end_draw );
#endif /* HELP_ALERTS */
extern  WORD inf_file( BYTE far * ppath, FNODE far *pfnode );
extern  WORD inf_folder( BYTE far * ppath, FNODE far *pf );
extern  WORD inf_disk( BYTE dr_id );
extern  WORD inf_pref( void );
extern  WORD opn_appl( BYTE *papname, BYTE *papparms, BYTE *pcmd, BYTE *ptail, WORD *isgemapp );


/* deskins.c 	--------------------------------------------------------*/ 
  
extern void update_icon_pair( TREE tree, WORD obj, WORD icon );
extern void size_scroller( TREE tree, WORD parent, WORD slots, WORD range );
extern void insa_elev( TREE tree, WORD parent, WORD item, WORD range );
extern void insa_icon( TREE tree, WORD obj, WORD nicon, ICONBLK *pic, BYTE *ptext );
extern void color_cats( TREE tree, WORD parent );
extern WORD hndl_scroller( TREE tree, WORD parent, WORD obj, 
					    WORD old_value, WORD range );
extern  WORD is_installed( ANODE *pa );


/* deskobj.c 	--------------------------------------------------------*/ 
  
extern  void obj_init( TREE tree, WORD num_objs, BOOLEAN include_wins );
extern  WORD obj_walloc( WORD x, WORD y, WORD w, WORD h );
extern  void obj_wfree( WORD obj, WORD x, WORD y, WORD w, WORD h );
extern  WORD obj_ialloc( WORD wparent, WORD x, WORD y, WORD w, WORD h );


/* deskpass.c 	--------------------------------------------------------*/

extern	void passw_global( void );
extern	WORD do_passw( WORD curr );
extern	WORD passw_chdir( BYTE far * pdrvpath );
extern	WORD passw_strip( LONG path );
extern	WORD passw_perror( BYTE far * path, WORD cnt, BOOLEAN end_draw );
extern	WORD passw_ferror( BYTE far * path, WORD cnt );
extern	void passw_tdf( BYTE * passwd );


/* deskpro.c 	--------------------------------------------------------*/ 
  
extern  WORD pro_chdir( WORD drv, BYTE *ppath );
extern  WORD pro_cmd( BYTE *psubcmd, BYTE *psubtail, WORD drive, BYTE *path, 
		WORD exitflag );
extern  WORD pro_run( WORD isgraf, WORD isover );
extern  WORD pro_exec( WORD isgraf, WORD isover, ULONG pcmd, ULONG ptail );
extern  WORD pro_exit( ULONG pcmd, ULONG ptail );


/* deskrsrc.c 	--------------------------------------------------------*/ 
  
extern  BYTE *ini_str( WORD stnum );


/* deskscsv.c 	--------------------------------------------------------*/
extern	void save_screen( void );
extern	void config_screensave( void );

/* desksupp.c 	--------------------------------------------------------*/ 
  
extern	WORD menu_item_to_alert_s( WORD def_but, WORD alert_num, WORD item );
extern  void desk_clear( WORD wh );
extern  void desk_verify( WORD wh, WORD changed );
extern  void do_wredraw( WORD w_handle, WORD xc, WORD yc, WORD wc, WORD hc );
extern  void get_xywh( OBJECT *olist, WORD obj, WORD *px, WORD *py, WORD *pw, WORD *ph );
extern  ICONBLK far * get_spec( OBJECT *olist, WORD obj );
extern  void do_xyfix( WORD *px, WORD *py );
extern  void do_wopen( WORD new_win, WORD wh, WORD curr, WORD x, WORD y, WORD w, WORD h );
extern  void do_wfull( WORD wh );
extern  WORD do_diropen( WNODE far *pw, WORD new_win, WORD curr_icon, WORD drv, 
		BYTE *ppath, BYTE *pname, BYTE *pext, GRECT *pt, WORD redraw );
extern	void do_cmdtail( BYTE *path, BYTE *name, BYTE *dest, BYTE drv );
extern  WORD do_aopen( ANODE *pa, WORD isapp, WORD drv, BYTE *ppath, 
		BYTE far *pname );
extern  BOOLEAN do_fopen( WNODE far *pw, WORD curr, WORD drv, BYTE *ppath, BYTE *pname, 
		BYTE *pext, WORD chkall, WORD redraw );
extern  WORD do_open( WORD curr );
extern	WORD do_info( WORD curr );
extern	WORD do_wild( void );
extern	WORD do_copy( WORD curr );
extern  WORD do_passw( WORD curr );
extern	BYTE far *do_find( WNODE far *pw );
extern  void vid_dial( UWORD int_ch );
extern  void romerr( void );
#if FSAFMT
extern  WORD do_format( WORD curr );
#else /* FSAFMT */
extern  void do_format( WORD curr );
#endif /* FSAFMT */
extern  void do_chkall( WORD redraw );
extern	void do_chk( WORD redraw );
extern	void release_last_find( void );
extern	void goto_file( BYTE far * dest, WORD curr, WNODE far *pw );
extern	WORD do_undelete( WNODE far *pw );


/* desktmax.c 	--------------------------------------------------------*/

extern	void taskmax( WORD );
extern	void taskmax_prefs( void );
extern	void check_for_taskmax( void );
extern  WORD SaveTMLIMSize( void );

/* deskmain.c 	--------------------------------------------------------*/ 
  
extern	void hilite_obj( WORD );
extern	void enable_cursor( void );
extern	void disable_cursor( void );
extern	void cursor_init( void );
extern	void cursor_set( FNODE far* file_object, GRECT *r );
extern	BYTE far * extract( BYTE far * thepath, BYTE far * dststr );
extern	void cursor_move( BYTE far * thepath );
extern  void desk_wait( WORD turnon );
extern  void desk_all( void );
extern  ANODE *i_find( WORD wh, WORD item, FNODE far * *ppf, WORD *pisapp );
extern  void men_list( TREE mlist, BYTE *dlist, WORD enable );
extern  WORD hndl_button( WORD clicks, WORD mx, WORD my, WORD button, WORD keystate );
extern  WORD hndl_kbd( WORD theBYTE );
extern  WORD hndl_menu( WORD title, WORD item );
extern  void hot_close( WORD wh );
extern  WORD hndl_msg( void );
extern  WORD gemain( void );
extern  WORD do_viewmenu( WORD item );
extern  void cnx_put( void ) ;
extern	void men_update( TREE tree ) ;

/* deskinit.c 	--------------------------------------------------------*/

extern WORD init( void ) ;
extern WORD cleanup( void ) ;

/* desktree.c 	--------------------------------------------------------*/

extern	BOOLEAN	tree_init( void );
extern	void	tree_deinit( void );
extern	void	tree_dirty( BYTE drv );
extern	BOOLEAN tree_save( FNODE far *flist );
extern	WORD	tree_open( PNODE far * thepath, BOOLEAN end_draw );
extern	void	tree_parse( PNODE far * thepath );
extern	void	tree_pspec( PNODE far * thepath );
extern	void	tree_rename( BYTE *thepath, BYTE far *newname );
extern	void	tree_add( BYTE *newpath );
extern	void	tree_delete( BYTE *newpath );

/* desktype.c 	--------------------------------------------------------*/

extern void handle_message( WORD *message, WORD wh );
extern	WORD do_type( WORD curr );


/* deskwin.c 	--------------------------------------------------------*/ 
  
extern  WORD create_window( WORD wkind, BYTE * title, BYTE * info, GRECT *work );
extern	void close_window( WORD whandle ) ;
extern	void win_vcalc( WORD win );
extern  void win_view( WNODE far * pw, WORD vtype, WORD isort );
extern  void win_start( void );
extern  void win_free( WNODE far *thewin );
extern  WNODE far * win_alloc( WORD split, WSAVE *pws );
extern  WNODE far * win_find( WORD wh );
extern  void win_top( WNODE far *thewin );
extern	void win_vistop( WORD wh, BOOLEAN co_top );
extern  WORD win_cnt( WORD level );
extern  WNODE far * win_ith( WORD level );
extern  void win_ocalc( WNODE far *pwin, WORD wfit, WORD hfit, FNODE far * *ppstart );
extern  void win_icalc( FNODE far *pfnode );
extern  WORD win_bldview( WNODE far *pwin, WORD x, WORD y, WORD w, WORD h );
extern  void win_blt( WNODE far *pw, WORD newcv );
extern  void win_slide( WORD wh, WORD sl_value, BOOLEAN type );
extern  void win_arrow( WORD wh, WORD arrow_type );
extern	void win_rebuild( void );
extern	WORD win_show( WNODE far *pw );
extern  WORD win_isel( OBJECT *olist, WORD root, WORD curr );
extern  BYTE *add_commas( long val );
extern	void win_stitle( BYTE *srctitle, WORD wh );
extern  void win_sname( WNODE far *pw );
extern	WNODE far *win_join( WNODE far *pw );
extern	WNODE far *win_split( WNODE far *pw );
extern	WORD win_contents( void );
extern  void fix_wins( void );
extern	void win_movsiz( WNODE far *pw, GRECT *request );


/* gembind.c 	--------------------------------------------------------*/ 
  
extern  WORD gem_if( WORD opcode );
extern  WORD appl_init( void );
extern  WORD appl_exit( void );
extern  WORD appl_write( WORD rwid, WORD length, ULONG pbuff );
extern  WORD appl_read( WORD rwid, WORD length, ULONG pbuff );
extern  WORD appl_find( ULONG pname );
extern  WORD appl_tplay( ULONG tbuffer, WORD tlength, WORD tscale );
extern  WORD appl_trecord( ULONG tbuffer, WORD tlength );
extern  WORD appl_bvset( UWORD bvdisk, UWORD bvhard );
extern  UWORD evnt_keybd( void );
extern  WORD evnt_button( WORD clicks, UWORD mask, UWORD state, UWORD *pmx, 
		UWORD *pmy, UWORD *pmb, UWORD *pks );
extern  WORD evnt_mouse( WORD flags, WORD x, WORD y, WORD width, WORD height, 
		WORD *pmx, WORD *pmy, WORD *pmb, WORD *pks );
extern  WORD evnt_mesag( ULONG pbuff );
extern  WORD evnt_timer( UWORD locnt, UWORD hicnt );
extern  WORD evnt_multi( UWORD flags, UWORD bclk, UWORD bmsk, UWORD bst, 
		UWORD m1flags, UWORD m1x, UWORD m1y, UWORD m1w, UWORD m1h, 
		UWORD m2flags, UWORD m2x, UWORD m2y, UWORD m2w, UWORD m2h, 
		ULONG mepbuff, UWORD tlc, UWORD thc, UWORD *pmx, UWORD *pmy, 
		UWORD *pmb, UWORD *pks, UWORD *pkr, UWORD *pbr );
extern  WORD evnt_dclick( WORD rate, WORD setit );
extern  WORD menu_bar( TREE tree, WORD showit );
extern  WORD menu_icheck( TREE tree, WORD itemnum, WORD checkit );
extern  WORD menu_ienable( TREE tree, WORD itemnum, WORD enableit );
extern  WORD menu_tnormal( TREE tree, WORD titlenum, WORD normalit );
extern  WORD menu_text( TREE tree, WORD inum, ULONG ptext );
extern  WORD menu_register( WORD pid, ULONG pstr );
extern  WORD menu_unregister( WORD mid );
extern  WORD menu_click( WORD click, WORD setit );
extern  WORD objc_add( TREE tree, WORD parent, WORD child );
extern  WORD objc_delete( TREE tree, WORD delob );
extern  WORD objc_draw( TREE tree, WORD drawob, WORD depth, WORD xc, WORD yc, 
		WORD wc, WORD hc );
extern  WORD objc_find( TREE tree, WORD startob, WORD depth, WORD mx, WORD my );
extern  WORD objc_order( TREE tree, WORD mov_obj, WORD newpos );
extern  WORD objc_offset( TREE tree, WORD obj, WORD *poffx, WORD *poffy );
extern  WORD objc_edit( TREE tree, WORD obj, WORD inchar, WORD *idx, WORD kind );
extern  WORD objc_change( TREE tree, WORD drawob, WORD depth, WORD xc, WORD yc, 
		WORD wc, WORD hc, WORD newstate, WORD redraw );
extern  WORD form_do( ULONG form, WORD start );
extern  WORD form_dial( WORD dtype, WORD ix, WORD iy, WORD iw, WORD ih, 
		WORD x, WORD y, WORD w, WORD h );
extern  WORD form_alert( WORD defbut, ULONG astring );
extern  WORD form_error( WORD errnum );
extern  WORD form_center( TREE tree, WORD *pcx, WORD *pcy, WORD *pcw, WORD *pch );
extern  WORD form_keybd( TREE form, WORD obj, WORD nxt_obj, WORD thechar, 
		WORD *pnxt_obj, WORD *pchar );
extern  WORD form_button( TREE form, WORD obj, WORD clks, WORD *pnxt_obj );
extern  WORD proc_create( ULONG ibegaddr, ULONG isize, WORD isswap, WORD isgem, 
		WORD *onum );
extern  WORD proc_run( WORD proc_num, WORD isgraf, WORD isover, ULONG pcmd, ULONG ptail );
extern  WORD proc_delete( WORD proc_num );
extern  WORD proc_info( WORD num, WORD *oisswap, WORD *oisgem, ULONG *obegaddr, ULONG *ocsize, ULONG *oendmem, ULONG *ossize, ULONG *oWORDtbl );
extern  ULONG proc_malloc( ULONG csize, ULONG *adrcsize );
extern  WORD proc_switch( WORD pid );
extern  WORD proc_shrink( WORD pid );
extern  WORD graf_rubbox( WORD xorigin, WORD yorigin, WORD wmin, WORD hmin, 
		WORD *pwend, WORD *phend );
extern  WORD graf_dragbox( WORD w, WORD h, WORD sx, WORD sy, WORD xc, WORD yc, 
		WORD wc, WORD hc, WORD *pdx, WORD *pdy );
extern  WORD graf_mbox( WORD w, WORD h, WORD srcx, WORD srcy, WORD dstx, WORD dsty );
extern  WORD graf_watchbox( TREE tree, WORD obj, UWORD instate, UWORD outstate );
extern  WORD graf_slidebox( TREE tree, WORD parent, WORD obj, WORD isvert );
extern  WORD graf_handle( WORD *pwchar, WORD *phchar, WORD *pwbox, WORD *phbox );
extern  WORD graf_mouse( WORD m_number, ULONG m_addr );
extern  void graf_mkstate( WORD *pmx, WORD *pmy, WORD *pmstate, WORD *pkstate );
extern  WORD scrp_read( ULONG pscrap );
extern  WORD scrp_write( ULONG pscrap );
extern  WORD fsel_input( ULONG pipath, ULONG pisel, WORD *pbutton );
extern  WORD wind_create( UWORD kind, WORD wx, WORD wy, WORD ww, WORD wh );
extern  WORD wind_open( WORD handle, WORD wx, WORD wy, WORD ww, WORD wh );
extern  WORD wind_close( WORD handle );
extern  WORD wind_delete( WORD handle );
extern  WORD wind_get( WORD w_handle, WORD w_field, WORD *pw1, WORD *pw2, 
		WORD *pw3, WORD *pw4 );
extern  WORD wind_set( WORD w_handle, WORD w_field, WORD w2, WORD w3, WORD w4, 
		WORD w5 );
extern  WORD wind_set2( WORD w_handle, WORD w_field, LONG w2w3, WORD w4, 
		WORD w5 );
extern  WORD wind_find( WORD mx, WORD my );
extern  WORD wind_update( WORD beg_update );
extern  WORD wind_calc( WORD wctype, UWORD kind, WORD x, WORD y, WORD w, 
		WORD h, WORD *px, WORD *py, WORD *pw, WORD *ph );
extern  WORD rsrc_load( ULONG rsname );
extern  WORD rsrc_free( void );
extern  WORD rsrc_gaddr( WORD type, WORD id, TREE * ptree );
extern  WORD rsrc_saddr( WORD rstype, WORD rsid, ULONG lngval );
extern  WORD rsrc_obfix( TREE tree, WORD obj );
extern  WORD shel_read( ULONG pcmd, ULONG ptail );
extern  WORD shel_write( WORD doex, WORD isgr, WORD iscr, ULONG pcmd, ULONG ptail );
extern  WORD shel_get( ULONG pbuffer, WORD len );
extern  WORD shel_put( ULONG pdata, WORD len );
extern  WORD shel_find( ULONG ppath );
extern  WORD shel_envrn( ULONG ppath, ULONG psrch );
extern  WORD shel_rdef( ULONG lpcmd, ULONG lpdir );
extern  WORD shel_wdef( ULONG lpcmd, ULONG lpdir );
extern	WORD devnt_multi( EVMULT *em );
extern	WORD xgrf_dtimage( FDB FAR *image );

/* gemdos.c 	--------------------------------------------------------*/ 
  
extern  void dos_func( UWORD ax, ULONG dsdx );
extern  void dos_chdir( ULONG pdrvpath );
extern  WORD dos_gdir( WORD drive, ULONG pdrvpath );
extern  WORD dos_gdrv( void );
extern  WORD dos_sdrv( WORD newdrv );
extern  void dos_sdta( FCB far * pFCB );
extern  FCB far * dos_gdta( void );
extern  WORD dos_sfirst( char far * pspec, WORD attr );
extern  WORD dos_snext( void );
extern  WORD dos_open( ULONG pname, WORD access );
extern  WORD dos_close( WORD handle );
extern  WORD dos_read( WORD handle, WORD cnt, ULONG pbuffer );
extern  ULONG dos_lseek( WORD handle, WORD smode, ULONG sofst );
extern  ULONG dos_alloc( ULONG nbytes );
extern  ULONG dos_avail( void );
extern  WORD dos_free( ULONG maddr );
extern	void dos_gettime( WORD *hours, WORD *minutes, WORD *seconds, WORD *hsec );
extern  void dos_label( BYTE drive, BYTE *plabel );
extern  void dos_space( WORD drv, ULONG *ptotal, ULONG *pavail );
extern	WORD dos_dtype( WORD drv );
extern	WORD dos_ldt( void );
extern  WORD dos_rmdir( ULONG ppath );
extern  WORD dos_create( ULONG pname, WORD attr );
extern  WORD dos_mkdir( ULONG ppath );
extern  WORD dos_delete( ULONG pname );
extern  WORD dos_rename( ULONG poname, ULONG pnname );
extern  WORD dos_write( WORD handle, WORD cnt, ULONG pbuffer );
extern  WORD dos_chmod( ULONG pname, WORD func, WORD attr );
extern  void dos_setdt( WORD handle, WORD time, WORD date );
extern	WORD lim_driver_present( void );
extern	void dos_get_country( LONG nat );
extern	WORD tm_install_check( void );
extern	WORD tm_status( WORD *max_tasks, WORD *our_index, WORD *version, 
		LONG *task_ids, LONG *task_names );
extern	WORD tm_get_ems_limit( void );
extern	void tm_set_ems_limit( WORD limit );
extern	WORD tm_register_mgr( void );
extern	WORD tm_unregister_mgr( void );
extern	void tm_enable_switching( void );
extern	void tm_disable_switching( void );
extern	WORD tm_switch( WORD index );
extern	WORD tm_create_task( BYTE *progpath, BYTE *parm_str, BYTE *fcb_area );
extern	void tm_destroy_task( WORD index );
extern	WORD tm_name_task( WORD task_id, BYTE far * new_name );
extern	WORD tm_check_open_files( WORD task_index );
extern	BOOLEAN	tm_at_root_proc( WORD task_index );
extern	WORD tm_get_swap_space( WORD *total );
extern	WORD lim_get_pages( void );


/* ems.c 	--------------------------------------------------------*/

extern	BYTE EMS_Init( BYTE *emm_vers, WORD *pf_addr, WORD *ppgs, WORD *lpgs );
extern	WORD EMS_Avail( void );
extern	WORD EMS_Alloc( WORD num_pages );
extern	BYTE EMS_Map( WORD handle, BYTE ppage, WORD lpage );
extern	void EMS_Free( WORD handle );


/* memyman.c 	--------------------------------------------------------*/

extern void	Free_Memory( void ) ;
extern BOOLEAN	Get_Memory( WORD size, void far **memptr ) ;

/* optimize.c 	--------------------------------------------------------*/ 
  
extern  WORD v_sound( WORD isfreq, WORD freq, WORD dura );
extern  void rc_union( GRECT *p1, GRECT *p2 );
extern  WORD rc_intersect( GRECT *p1, GRECT *p2 );
extern	BYTE *strscn( BYTE *ps, BYTE *pd, BYTE stop );
extern  void fmt_str( BYTE *instr, BYTE *outstr );
extern  void unfmt_str( BYTE *instr, BYTE *outstr );
extern  void tedinfo_set( TREE tree, WORD obj, BYTE far *pstr );
extern  void tedinfo_get( TREE tree, WORD obj, BYTE far *pstr );
extern  WORD radio_get( TREE tree, WORD baseobj, WORD numobj );
extern  WORD inf_what( TREE tree, WORD okobj, WORD canobj );
extern  void merge_str( BYTE *pdst, BYTE *ptmp, UWORD *parms );
extern  WORD wildcmp( BYTE *pwld, BYTE *ptst );

/* deskpgrp.c 	--------------------------------------------------------*/

extern WORD NewIconDial( char far * fname, ANODE * pa );
extern WORD NewProgramItem( WNODE far * pw, FNODE far * pf, INODE * pa );
extern WORD NewProgramGroup( void );

/************************************************************************/
/*	A   S   S   E   M   B   L   E   R				*/

/* deskosif.a86	--------------------------------------------------------*/

extern	WORD dos_exec( BYTE *progpath, BYTE *parm_str, BYTE *fcb_area );
extern	WORD do_create_task( BYTE *progpath, BYTE *parm_str, BYTE *fcb_area );
extern	void __DOS( void );
extern  void __TM( void );
extern  void __LIM( void );
extern	void takevid( void );
extern	void givevid( void );


/* deskstar.a86 --------------------------------------------------------*/

extern	void gem( LONG addr );
extern	void debug_ru( void );


/* gsx2.a86 	--------------------------------------------------------*/

extern	void gsx2( void );
extern	WORD mul_div( WORD m1, WORD m2, WORD d1 );
extern	WORD umul_div( WORD m1, WORD m2, WORD d1 );
extern	void i_ptsin( WORD *xyarray );
extern	void i_intin( WORD *work_in );
extern	void i_intout( WORD *work_out );
extern	void i_ptsout( WORD *xyarray );
extern	void i_ptr( WORD *pMFDB );
extern	void i_ptr2( WORD *pMFDB );


/* longasm.a86 	--------------------------------------------------------*/

extern	LONG LLDS( void );					


/* optimopt.a86	--------------------------------------------------------*/

extern	void r_get( void *pxywh, WORD *px, WORD *py, WORD *pw, WORD *ph );
extern	void r_set( void *pxywh, WORD x, WORD y, WORD w, WORD h );
extern	WORD rc_equal( GRECT *p1, GRECT *p2 );
extern	void rc_copy( void *psxywh, void *pdxywh );
extern	UWORD inside( WORD x, WORD y, GRECT *pt );

#endif /* ndef PROTO_INCLUDED */

/*
 *	EOF:	proto.h
 */
