/*	SLIDER.C		06/17/1988		Dan Brown	    */
/*****************************************************************************
slider.c		Extended Object C Sources		       SLIDER
******************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *

Copyright (c) 1985,1988 Digital Research Inc. All rights reserved.  The
Software Code contained in this listing is proprietary to Digital Research
Inc., Monterey, California, and is covered by U.S. and other copyright
protection. Unauthorized copying, adaption, distribution, use or display
is prohibited and may be subject to civil and criminal penalties.
Disclosure to others is prohibited. For the terms and conditions of
software code use, refer to the appropriate Digital Research License
Agreement.
			U.S. GOVERNMENT RESTRICTED RIGHTS
				
This software product is provided with RESTRICTED RIGHTS.  Use,
duplication or disclosure by the Government is subject to restrictions as
set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or the
applicable provisions of the DOD FAR supplement 252.227-7013 subdivision
(b) (3) (ii) (May, 1981) or subdivision (c) (1) (ii) (May, 1987).
Contractor/manufacturer is Digital Research Inc. / 70 Garden Court / BOX
DRI / Monterey, CA 93940.
*******************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/slider.c 3.1 91/08/19 16:42:49 system Exp $

Date	Who	SPR#	Comments
------- ----	----	------------------------------------------------------
910429	RSF		Make sld_adjust global.
910327	RSF		Adapt for use with ViewMAX
******************************************************************************/

#include "shell.h"
#include "funcdef.h"
#include "danutil.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"

#define SLD_LINE    0x5555

/* LINE END STYLES */
#define LE_SQUARE 0
#define LE_ARROW 1
#define LE_ROUND 2

#define vsl_udsty( x )		gsx_1code(ST_UD_LINE_STYLE, x)

EXTERN	SCRN	screen;			/* Misc. screen information.	    */

/*--------------------------------------------------------------------------*/
/* NAME: sld_slide							    */
/*									    */
/* PURPOSE: Move slider knob.						    */
/*									    */
/*  INPUT:  EVMULT	*evm	-   Event multi data structure.		    */
/*	    TREE	tree	-   Tree for current object.		    */
/*	    WORD	obj	-   object number.			    */
/*	    WORD	off_x	-   initial x offset of the mouse.	    */
/*	    WORD	off_y	-   initial y offset of the mouse.	    */
/*	    FSLIDER	*sld	-   Pointer to slider data.		    */
/*									    */
/* OUTPUT:  WORD	return()-   TRUE if successful, otherwise FALSE.    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
sld_slide(
    EVMULT	*evm,
    TREE	tree,
    WORD	obj, 
    WORD	off_x, 
    WORD	off_y,
    FSLIDER	*sld )
{
    WORD	left, right;		/* Left and right bounds for knob.  */
    WORD	new_x;			/* New position of the slider.	    */
    LONG	new_val;		/* New value.			    */
    WORD	slider;			/* Slider object number.	    */

    FDOBJECT	*knob_ptr;		/* Pointer to  knob object.	    */
    RECT	r;			/* Utility rectangle.		    */
    VOID	(* func)(FBYTE *, SLONG, WORD);/* Pointer to update function.*/
    
    FWORD	*knob_w;		/* Pointer to knob width.	    */
    WORD	*r_x, *r_w, *offset, *b1_x, *b2_x;
    UWORD	*m_x;
    
    slider = find_exobj( sld->sld_exob.exob_tree, sld->sld_exob.exob_obj,
			 SLD_AREA );

    knob_ptr = tree + obj;

    if( sld->sld_type & SLD_HORIZONTAL )
    {
	r_x = &r.x;
	r_w = &r.w;
	knob_w = &knob_ptr->ob_box.w;
	m_x = &evm->em_mstat.mst_x;
	offset = &off_x;
	b1_x = &evm->em_1box.x;
	b2_x = &evm->em_2box.x;
    }
    else
    {
	r_x = &r.y;
	r_w = &r.h;
	knob_w = &knob_ptr->ob_box.h;
	m_x = &evm->em_mstat.mst_y;
	offset = &off_y;
	b1_x = &evm->em_1box.y;
	b2_x = &evm->em_2box.y;
    }
    
	
    get_obloc( sld->sld_exob.exob_tree, slider, &r );
    left = *r_x;
    right = left + *r_w - *knob_w;
    
    new_x = mid( left, *m_x - *offset, right );
    if( new_x != *b2_x )
    {
	
	/* Remove existing rectangle.					    */
	vsl_udsty( SLD_LINE );
	vst_lattr( MD_XOR, LT_USERDEF, BLACK, LE_SQUARE, LE_SQUARE, 1 );
	graf_mouse( M_OFF, 0L );
	do_linebox( &evm->em_2box );

	/* Draw new box.						    */
	*b1_x = *b2_x = new_x;
	do_linebox( &evm->em_2box );
	graf_mouse( M_ON, 0L );

	/* Calculate new value.						    */
	new_val = scrn_to_val( (LONG)(*b2_x - left),
			      &sld->sld_trans );
	func = sld->sld_func;		/* Do this to overcome Metaware bug */
	(* func)( (FBYTE *)sld, new_val, TRUE );
    }
    return( TRUE );
}

/*--------------------------------------------------------------------------*/
/* NAME: sld_adjust							    */
/*									    */
/* PURPOSE: Adjusts the slider according to the increment passed in.	    */
/*									    */
/*  INPUT:  FSLIDER	*sld	    -   Pointer to slider data.		    */
/*	    SLONG	increment   -   step size.			    */
/*									    */
/* OUTPUT:  FSLIDER	*sld	-   Current value is adjusted.		    */
/*	    WORD	return()-   TRUE if successful, Otherwise FALSE.    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
sld_adjust(
    FSLIDER	*sld,
    SLONG	increment )
{
    SLONG	val, shift;
    VOID	(* func)( FBYTE *, SLONG, WORD );/* Slider update function. */

    shift = ( (labs(increment) - 1) >> 1 ) * ( (increment < 0) ? -1 : 1 );
    val = sld->sld_val + increment - shift;
    val = lround( val, labs(increment) );
    val = lmid( sld->sld_min, val, sld->sld_max );
    
    if( val != sld->sld_val )
    {
	func = sld->sld_func;		/* Do this to overcome Metaware bug */
	(* func)( (FBYTE *)sld, val, TRUE );
	snap_knob( sld, TRUE );
	return( TRUE );
    }
    return( FALSE );
}

/*--------------------------------------------------------------------------*/
/* NAME: sld_downarrow							    */
/*									    */
/* PURPOSE: Adjusts a value box one step up.				    */
/*									    */
/*  INPUT:  EVMULT	*evm	-   Event multi data structure.		    */
/*	    TREE	tree	-   Tree for current object.		    */
/*	    WORD	obj	-   object number.			    */
/*	    WORD	off_x	-   initial x offset of the mouse.	    */
/*	    WORD	off_y	-   initial y offset of the mouse.	    */
/*	    FSLIDER	*sld	-   Pointer to slider data.		    */
/*									    */
/* OUTPUT:  WORD	return()-   TRUE if successful, otherwise FALSE.    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
sld_downarrow(
    EVMULT	*evm,		/* params must be here, even if not	*/
    TREE	tree,		/* used, for symmetry with other funcs	*/
    WORD	obj, 
    WORD	off_x, 
    WORD	off_y,
    FSLIDER	*sld )
{
    return( sld_adjust( sld, -sld->sld_minor ) );
}

/*--------------------------------------------------------------------------*/
/* NAME: sld_uparrow							    */
/*									    */
/* PURPOSE: Adjusts a value box one step up.				    */
/*									    */
/*  INPUT:  EVMULT	*evm	-   Event multi data structure.		    */
/*	    TREE	tree	-   Tree for current object.		    */
/*	    WORD	obj	-   object number.			    */
/*	    WORD	off_x	-   initial x offset of the mouse.	    */
/*	    WORD	off_y	-   initial y offset of the mouse.	    */
/*	    FSLIDER	*sld	-   Pointer to slider data.		    */
/*									    */
/* OUTPUT:  WORD	return()-   TRUE if successful, otherwise FALSE.    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
sld_uparrow(
    EVMULT	*evm,		/* params must be here, even if not	*/
    TREE	tree,		/* used, for symmetry with other funcs	*/
    WORD	obj, 
    WORD	off_x,
    WORD	off_y,
    FSLIDER	*sld )
{
    return( sld_adjust( sld, sld->sld_minor ) );
}

/*--------------------------------------------------------------------------*/
/* NAME: sld_dwarea							    */
/*									    */
/* PURPOSE: Adjusts a slider major step down.				    */
/*									    */
/*  INPUT:  EVMULT	*evm	-   Event multi data structure.		    */
/*	    TREE	tree	-   Tree for current object.		    */
/*	    WORD	obj	-   object number.			    */
/*	    WORD	off_x	-   initial x offset of the mouse.	    */
/*	    WORD	off_y	-   initial y offset of the mouse.	    */
/*	    FSLIDER	*sld	-   Pointer to slider data.		    */
/*									    */
/* OUTPUT:  WORD	return()-   TRUE if successful, otherwise FALSE.    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
sld_dwarea(
    EVMULT	*evm,		/* params must be here, even if not	*/
    TREE	tree,		/* used, for symmetry with other funcs	*/
    WORD	obj, 
    WORD	off_x,
    WORD	off_y,
    FSLIDER	*sld )
{
    WORD	ret;			/* Return value.		    */
    WORD	knob;			/* object number of knob.	    */
    
    ret = sld_adjust( sld, -sld->sld_major );

    knob = find_exobj( tree, obj, SLD_KNOB );
    get_obloc( tree, knob, &evm->em_2box );

    return( ret );
}

/*--------------------------------------------------------------------------*/
/* NAME: sld_up_area							    */
/*									    */
/* PURPOSE: Adjusts a slider major step up.				    */
/*									    */
/*  INPUT:  EVMULT	*evm	-   Event multi data structure.		    */
/*	    TREE	tree	-   Tree for current object.		    */
/*	    WORD	obj	-   object number.			    */
/*	    WORD	off_x	-   initial x offset of the mouse.	    */
/*	    WORD	off_y	-   initial y offset of the mouse.	    */
/*	    FSLIDER	*sld	-   Pointer to slider data.		    */
/*									    */
/* OUTPUT:  WORD	return()-   TRUE if successful, otherwise FALSE.    */
/*--------------------------------------------------------------------------*/
    MLOCAL WORD
sld_up_area(
    EVMULT	*evm,		/* params must be here, even if not	*/
    TREE	tree,		/* used, for symmetry with other funcs	*/
    WORD	obj, 
    WORD	off_x,
    WORD	off_y,
    FSLIDER	*sld )
{
    WORD	ret;			/* Return value.		    */
    WORD	knob;			/* object number of knob.	    */
    
    ret = sld_adjust( sld, sld->sld_major );

    knob = find_exobj( tree, obj, SLD_KNOB );
    get_obloc( tree, knob, &evm->em_2box );

    return( ret );
}

/*--------------------------------------------------------------------------*/
/* NAME: sld_update							    */
/*									    */
/* PURPOSE: To update a slider.						    */
/*									    */
/* INPUT:   FDOBJECT	*tree	-   Pointer to tree.			    */
/*	    WORD	obj	-   Object number of the selected object.   */
/*	    MSTAT	*mst	-   Current mouse state.		    */
/*									    */
/* OUTPUT:  VALUE	*sld	-   The current slider will be updated.	    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
sld_update( FDOBJECT	*tree,
	    WORD	obj,
	    MSTAT	*mst
	    )
{
    EVMULT	evm;			/* EventMulti data structure.	    */
    FDOBJECT	*arrow_obj;		/* Pointer to selected arrow object */
    FDOBJECT	*parent_obj;		/* Pointer to parent object.	    */
    FAPPLBLK	*ab;			/* Pointer to application block.    */
    FSLIDER	*sld;			/* Pointer to value box data.	    */
    WORD	part;			/* Part number of arrow.	    */
    WORD	parent;			/* Object number of the parent.	    */
    WORD	knob;			/* Object number of the knob.	    */
    WORD	(* func)();		/* Pointer to event loop function.  */
    
    init_evmulti( &evm );
    arrow_obj = tree + obj;
    arrow_obj->ob_state &= ~SELECTED;	/* RSF: so not left on in ViewMAX */
    
    part = exobj_num( tree, obj );
    parent = find_exparent( tree, obj, SLD_PARENT );
    parent_obj = tree + parent;
    ab = (FAPPLBLK *)parent_obj->ob_spec;
    sld = (FSLIDER *)ab->ab_parm;
    
    evm.em_events = MU_BUTTON | MU_M1;
    evm.em_bst = BUTTON_UP;
    evm.em_1inout = RETURN_ON_EXIT;
    evm.em_time = (LONG)((5 - evnt_dclick( 0, GET_DCLICK )) * 100);
    evm.em_time = ( evm.em_time < 200L ) ? 200L : evm.em_time;
    fmemcpy( (void far *)&evm.em_mstat,  (void far *)mst, sizeof(MSTAT) );
    
    switch( part )
    {
	case SLD_UP:
	    evm.em_events |= MU_TIMER;
	    get_obloc( tree, obj, &evm.em_1box );
	    evnt_loop( &evm, MU_BUTTON | MU_M1, tree, obj,
		       sld_uparrow, (FBYTE *)sld );
	    break;
	case SLD_DOWN:
	    evm.em_events |= MU_TIMER;
	    get_obloc( tree, obj, &evm.em_1box );
	    evnt_loop( &evm, MU_BUTTON | MU_M1, tree, obj,
		       sld_downarrow, (FBYTE *)sld );
	    break;
	case SLD_AREA:
	    evm.em_events |= (MU_TIMER | MU_M2);
	    get_obloc( tree, obj, &evm.em_1box );
	    knob = find_exobj( tree, parent, SLD_KNOB );
	    get_obloc( tree, knob, &evm.em_2box );
	    evm.em_2inout = RETURN_ON_ENTRY;
	    if( ( (sld->sld_type & SLD_HORIZONTAL) &&
		  (mst->mst_x < evm.em_2box.x) ) ||
		( !(sld->sld_type & SLD_HORIZONTAL) &&
		  (mst->mst_y < evm.em_2box.y) ) )
		func = sld_dwarea;
	    else
		func = sld_up_area;
	    evnt_loop( &evm, MU_BUTTON | MU_M1 | MU_M2, tree, obj,
		       func, (FBYTE *)sld );
	    break;
	case SLD_KNOB:
	    if( sld->sld_type & SLD_HORIZONTAL )
	    {
		evm.em_1box.x = evm.em_mstat.mst_x;
		evm.em_1box.y = 0;
		evm.em_1box.w = 1;
		evm.em_1box.h = screen.sc_mfdb.fd_h;
	    }
	    else
	    {
		evm.em_1box.x = 0;
		evm.em_1box.y = evm.em_mstat.mst_y;
		evm.em_1box.w = screen.sc_mfdb.fd_w;
		evm.em_1box.h = 1;
	    }
	    get_obloc( tree, obj, &evm.em_2box ); /* Use the second evm box */
						  /* track the knob.	    */
	    vsl_udsty( SLD_LINE );
	    vst_lattr( MD_XOR, LT_USERDEF, BLACK, LE_SQUARE, LE_SQUARE, 1 );
	    graf_mouse( M_OFF, 0L );
	    do_linebox( &evm.em_2box );
	    graf_mouse( M_ON, 0L );
	    evnt_loop( &evm, MU_BUTTON, tree, obj, sld_slide, (FBYTE *)sld );
	    vsl_udsty( SLD_LINE );
	    vst_lattr( MD_XOR, LT_USERDEF, BLACK, LE_SQUARE, LE_SQUARE, 1 );
	    graf_mouse( M_OFF, 0L );
	    do_linebox( &evm.em_2box );
	    graf_mouse( M_ON, 0L );
	    snap_knob( sld, TRUE );
	    break;
    }
    return( !( arrow_obj->ob_flags & EXIT ) );
}

/* slider.c */
