/*	TRNSRSC.C		06/04/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    	Copyright (c) 1988,1992 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* This module contains the functions to fixup the resource after it has    */
/* been loaded. It does transform on the images and icons. It allocates	    */
/* and initializes the data structures for the complex resource objects.    */
/* The resource is walked through twice. The first time the amount of extra */
/* memory needed is calculated. On the second pass the complex object data  */
/* structures are allocated and initialized. This additional buffer is	    */
/* called the resource annex buffer.					    */
/*--------------------------------------------------------------------------*/

/****************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/trnsrsc.c 3.3 92/04/03 17:12:37 sbc Exp $
$Log:	trnsrsc.c $
 * Revision 3.3  92/04/03  17:12:37  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.2  92/03/13  14:43:38  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 

Date	Who	SPR#	Comments
------- ------- ----	------------------------------------------------------
911126  K.H		Optimized by DRJ. (#if JOPTIMIZE)
910613	WHF		Dialogs transformed for pleasing or 3D effects
910502	RSF		Prototype atoi. Can't include stdlib due to collision
			w/ our min/max.
910425	RSF		Color category for valuebox sliders.
910421	RSF		3-D flag for valuebox sliders.
910408	RSF		Set flags for listbox items to use new AES 3-D-ing.
910321	RSF		Adapted from PT/OUTPUT for Viewmax use. Stripped out
			menu- and popup-related stuff.
*****************************************************************************/

#define DIALOG3D 1

#include "shell.h"
#include "list .h"
#include "exobdefs.h"
#include "exproto.h"

extern	WORD far	(* DRAWADDR)();

extern	GM_GLOB	global;			/* Global array for AES.	    */
extern	UWORD	DOS_ERR;		/* Error value from DOS call.	    */
extern	WORD	gl_nplanes;		/* how many planes of color 	    */

GLOBAL	SCRN	screen;			/* Misc. screen info.		    */
GLOBAL  BYTE far	*annex_addr = (BYTE far *)0 ;	/* Address of annex.	    */

#if CUA_BUTTONS
MLOCAL	short	first_radio;
MLOCAL	short	first_toggle;
extern	short far	*NormalRbutton;			/* RADIO	    */
extern	short far	*SelctdRbutton;			/* RADIO	    */
#endif /* CUA_BUTTONS */

/*--------------------------------------------------------------------------*/
/* NAME: screen_parm							    */
/*									    */
/* PURPOSE: This function set the values for the global screen data	    */
/*	    structure.							    */
/*--------------------------------------------------------------------------*/
    GLOBAL void
screen_parm( WORD	vdi_handle	/* Handle for the screen virtual    */
					/* workstation.			    */
	     )
{
    WS		ws;			/* Workstation data.		    */
    EX_STAT	ex_ws;			/* Extended Workstation data.	    */
    RORW	sc_buff;		/* Quarter screen buffer info.	    */
    WORD	ch_w, ch_h, cl_w;

    screen.sc_handle = vdi_handle;	/* Set screen handle.		*/
    vq_extnd( 0, (WORD *)&ws );		/* Get workstation data.	*/
    vq_extnd( 1, (WORD *)&ex_ws );	/* Get extended			*/
					/* workstation data.		*/

    /* Set screen MFDB data.						    */
    set_mfdb( &screen.sc_mfdb, (BYTE far *)0L, ws.ws_xres+1, ws.ws_yres+1,
	      0, ex_ws.num_planes );
    
    /* Set pixel size.							    */
    screen.sc_pwidth = ws.ws_wpixel;
    screen.sc_pheight = ws.ws_hpixel;

    /* Set quarter screen buffer address and size.			    */
    wind_get( 0, WF_SCREEN, &sc_buff.rw_ary[0], &sc_buff.rw_ary[1], 
	    &sc_buff.rw_ary[2], &sc_buff.rw_ary[3] );
    screen.sc_qbuff = (BYTE far *)sc_buff.rw_lary[0];
    screen.sc_qlength = sc_buff.rw_lary[1];
    
    /* Set misc. information.						    */
    screen.sc_mn_chgt = ws.ws_chminh;	/* Minimum system character height. */
    screen.sc_mx_chgt = ws.ws_chmaxh;	/* Maximum system character height. */
    vst_font( 1 );
    vst_height( screen.sc_mx_chgt, &ch_w, &ch_h, &cl_w,
		&screen.sc_mx_clhgt );
    screen.sc_mx_points = ex_ws.max_points; /* Maximum points for vdi calls */
}

/*--------------------------------------------------------------------------*/
/* NAME: init_progdef							    */
/*									    */
/* PURPOSE: This function sets up the APPLBLK in the annex buffer and points*/
/*	    the ob_spec field to it.					    */
/*									    */
/* INPUT:   TREE	tree	-   Current tree address.		    */
/*	    WORD	obj	-   Current object number.		    */
/*	    FAPPLBLK	*ab	-   Pointer to next opening in the annex    */
/*				    buffer.				    */
/*									    */
/* OUTPUT:  FAPPLBLK	*return()-  Pointer to new next opening in annex    */
/*				    buffer.				    */
/*--------------------------------------------------------------------------*/
    GLOBAL FAPPLBLK
*init_progdef(
    TREE	tree,
    WORD	obj,
    FAPPLBLK	*ab )
{
    FDOBJECT	*cur_obj;
    
    cur_obj = tree + obj;
    cur_obj->ob_type = (cur_obj->ob_type & 0xFF00) | G_USERDEF;
    ab->ab_code = DRAWADDR;
    ab->ab_parm = (PARMBLK far *)cur_obj->ob_spec;
    cur_obj->ob_spec = (BYTE far *)ab ;
    
    return( ab + 1 );
}

/*--------------------------------------------------------------------------
*	Set flags of passed in object pointer to 3D and Use color category
*	and set its color.
*/
GLOBAL void set_3d_color(FDOBJECT *o_ptr, LONG color_cat)
{
    o_ptr->ob_flags |= USECOLORCAT | (color_cat == CC_BUTTON ? FLAG3D : 0);
    (LONG)o_ptr->ob_spec &= 0xFFFFFFF0L;
    (LONG)o_ptr->ob_spec |= color_cat;	
}

/*--------------------------------------------------------------------------*/
/* NAME: init_listbox							    */
/*									    */
/* PURPOSE: This function setup the data structure for a list box.	    */
/*									    */
/* INPUT:   TREE	tree	-   Current tree address.		    */
/*	    WORD	obj	-   Current object number.		    */
/*	    FVALUE	*lb	-   Pointer to next opening in the annex    */
/*				    buffer.				    */
/*									    */
/* OUTPUT:  FLISTBOX	*return()-  Pointer to new next opening in annex    */
/*				    buffer.				    */
/*									    */
/*--------------------------------------------------------------------------*/
    MLOCAL FLISTBOX
*init_listbox(
    TREE	tree,
    WORD	obj,
    FLISTBOX	*lb )
{
    FDOBJECT	*obj_ptr;
    FDOBJECT	*slot_ptr;
    WORD	slot;
    WORD	slots;
    BYTE	buf[80];
    BYTE far	*lb_info;
    
    lb->lb_sld.sld_exob.exob_tree = tree;
    lb->lb_sld.sld_exob.exob_obj = obj;
    lb->lb_sld.sld_type = SLD_PARENT;
    
    obj_ptr = tree + obj;
    
    lb_info = (BYTE far *)obj_ptr->ob_spec;
    
					/* Change LB parent to G_USERDEF.   */
    obj_ptr->ob_type = (SLD_PARENT << 8) | G_USERDEF;
    init_progdef( tree, obj, (FAPPLBLK *)(&lb->lb_sld.sld_exob.exob_ab) );
    lb->lb_sld.sld_exob.exob_ab.ab_parm = (PARMBLK far *)lb;
    
        
    lb_info = get_field( buf, lb_info );
    lb->dflt_flags = atoi( buf );	/* Default flags for slots.	    */
    
    lb_info = get_field( buf, lb_info );
    if( strlen( buf ) )
    {
	lb->lb_options = atoi( buf );
    }
    else
    {
	lb->lb_options = 0;
    }

    slots = find_exobj( lb->lb_sld.sld_exob.exob_tree,
		        lb->lb_sld.sld_exob.exob_obj, LB_SLOTS );
    slot_ptr = tree + slots;
    lb->num_slots = 0;
    for( slot = slot_ptr->ob_head; slot != slots; slot = slot_ptr->ob_next )
    {
	slot_ptr = tree + slot;
	if( exobj_num( tree, slot ) == LB_A_SLOT ||
	    slot_ptr->ob_type == G_ICON || slot_ptr->ob_type == G_IMAGE )
	{
	    lb->num_slots++;
	    slot_ptr->ob_type = (slot_ptr->ob_type & 0x00FF) |
				( LB_A_SLOT << 8 );
	}
    }

    lb->items = (FLIST *)0L;
    lb->ptr_strt_item = (FLISTITEM *)0L;
    lb->strt_item = 0;
    
    ls_init( (FLIST *)&lb->lb_mem );  /* Initialize memory list.	    */
    lb->lb_fstitem = (FLISTITEM *)0L;   /* No first item in built list.	    */
    
    lb->lb_bldfunc = 0;			/* Set to no list build function.   */
    lb->lb_blddata = (BYTE far *)0L;	/* Set to no list build data.	    */
    lb->slot_func = 0;
    
    return( lb + 1 );
}

/*--------------------------------------------------------------------------*/
/* NAME: init_value							    */
/*									    */
/* PURPOSE: This function initializes the value box data structure and	    */
/*	    sets ob_spec to point to it. The initial values for the data    */
/*	    are provided in the validation string of the tedinfo of VB_VALUE*/
/*	    part of the value box. The format of this string is as follows: */
/*									    */
/*		FIELD		    DESCRIPTION				    */
/*									    */
/* INPUT:   TREE	tree	-   Current tree address.		    */
/*	    WORD	obj	-   Current object number.		    */
/*	    FVALUE	*vb	-   Pointer to next opening in the annex    */
/*				    buffer.				    */
/*									    */
/* OUTPUT:  FVALUE	*return()-  Pointer to new next opening in annex    */
/*				    buffer.				    */
/*--------------------------------------------------------------------------*/
    MLOCAL FVALUE
*init_value(
    TREE	tree,
    WORD	obj,
    FVALUE	*vb )
{
    FDOBJECT	*obj_ptr ;
    FDOBJECT	*val_ptr ;
    FDOBJECT	*knob_ptr;
    FDOBJECT	*arrow_ptr;
    FDOBJECT	*area_ptr;
    FTEDINFO	*te;
    BYTE far	*init_str;
    
    vb->vb_sld.sld_exob.exob_tree = tree;
    vb->vb_sld.sld_exob.exob_obj = obj;
    vb->vb_sld.sld_type = SLD_VALUE;	/* Mark slider as value box.	    */
    vb->vb_sld.sld_type |= SLD_HORIZONTAL;
    
    obj_ptr = tree + obj;		/* Change VB parent to G_USERDEF.   */
    obj_ptr->ob_type = (SLD_PARENT << 8) | G_USERDEF;
    init_progdef( tree, obj, (FAPPLBLK *)(&vb->vb_sld.sld_exob.exob_ab) );
    vb->vb_sld.sld_exob.exob_ab.ab_parm = (PARMBLK far *)vb;

    val_ptr = tree + find_exobj( tree,obj,VB_VALUE ); /* Find the value part*/
    val_ptr->ob_type = (val_ptr->ob_type & 0xFF00) | G_BOXTEXT;	/* Change to*/
    te = (FTEDINFO *)val_ptr->ob_spec; /* G_BOXTEXT type.		    */
    init_str = (BYTE far *)te->te_pvalid;
    
    vb->vb_sld.sld_func = set_val;	/* Set update value function addr.  */
    
    knob_ptr = vb->vb_sld.sld_exob.exob_tree +
	       find_exobj( vb->vb_sld.sld_exob.exob_tree,
			   vb->vb_sld.sld_exob.exob_obj, SLD_KNOB );
    vb->vb_sld.sld_mnsize = knob_ptr->ob_box.w;

    /* Give 3-D effects and color categories to valuebox sliders */
    set_3d_color(knob_ptr, CC_BUTTON);

    arrow_ptr = vb->vb_sld.sld_exob.exob_tree + 
	       find_exobj( vb->vb_sld.sld_exob.exob_tree,
			   vb->vb_sld.sld_exob.exob_obj, SLD_UP);

    set_3d_color(arrow_ptr, CC_BUTTON);

    arrow_ptr = vb->vb_sld.sld_exob.exob_tree + 
	       find_exobj( vb->vb_sld.sld_exob.exob_tree,
			   vb->vb_sld.sld_exob.exob_obj, SLD_DOWN);
    set_3d_color(arrow_ptr, CC_BUTTON);

    area_ptr = vb->vb_sld.sld_exob.exob_tree + 
	       find_exobj( vb->vb_sld.sld_exob.exob_tree,
			   vb->vb_sld.sld_exob.exob_obj, SLD_AREA);
    set_3d_color(area_ptr, CC_SLIDER);
    
    /* Get initialization information from validation string.		    */
    vb_parse( vb, init_str );

    set_val( (BYTE far *)vb, vb->vb_sld.sld_val, FALSE ); /* Set initial value.*/
    snap_knob( &vb->vb_sld, FALSE );	/* Position knob.		    */
    
    return( vb + 1 );
}

/*--------------------------------------------------------------------------*/
/* NAME: trnfm_icon							    */
/*									    */
/* PURPOSE: Transforms an icon in the resource.				    */
/*--------------------------------------------------------------------------*/
    GLOBAL void
trnfm_icon( FDICONBLK	*icon		/* Pointer to icon block.	    */
	    )
{
	FDB	mf;
	
	set_mfdb( &mf, (BYTE far*)icon->ib_pmask, icon->ib_boxicon.w,
		  icon->ib_boxicon.h, TRUE, 1 );
	vrn_trnfm( (WORD *)&mf, (WORD *)&mf );
	mf.fd_addr = (LONG)icon->ib_pdata;
	mf.fd_stand = TRUE;
	vrn_trnfm( (WORD *)&mf, (WORD *)&mf );
}

/*--------------------------------------------------------------------------*/
/* NAME: trnfm_bitblk							    */
/*									    */
/* PURPOSE: Transforms a resource bitblock.				    */
/*--------------------------------------------------------------------------*/
    GLOBAL void
trnfm_bitblk( FBITBLK	    *bitblk	/* Pointer to bit block.	    */
	      )
{
	FDB	mf;
	
	set_mfdb( &mf, (BYTE far *)bitblk->bi_pdata, bitblk->bi_wb * 8,
		  bitblk->bi_hl, TRUE, 1 );
	vrn_trnfm( (WORD *)&mf, (WORD *)&mf );
}


/*--------------------------------------------------------------------------*/
/* NAME: trnfm_freeImage						    */
/*									    */
/* PURPOSE: Transforms free images in the resource.			    */
/*--------------------------------------------------------------------------*/
    MLOCAL void
trnfm_freeImage(
void		)
{
    WORD	count;			/* Current index for free image.    */
    FBITBLK	*(far *free_img);	/* Pointer to current free image.   */
    
    for( count = 0; count < global.ap_rsc->rsh_nimages; count++ )
    {
	rsrc_gaddr( R_FRIMG, count, (TREE *)&free_img );
	trnfm_bitblk( *free_img );
    }
}
#if CUA_BUTTONS
/*--------------------------------------------------------------------------*/
MLOCAL	BYTE far	*init_radio( TREE tree, short obj, BYTE far *annex )
{
    short    i, size;
    short    wch, hch, wcl, hcl;
    
    annex = (BYTE far *)init_progdef( tree, obj, (FAPPLBLK *)annex );
    
    if( first_radio )
    {
	size = Rbutton_size();
	NormalRbutton = (short far *)annex;
	for( i = 0; i < size/sizeof(short); i++ )
	    *(NormalRbutton+i) = 0;
	annex += size;
	SelctdRbutton = (short far *)annex;
	for( i = 0; i < size/sizeof(short); i++ )
	    *(SelctdRbutton+i) = 0;
	annex += size;
	graf_handle( (WORD*)&wch, (WORD*)&hch, (WORD*)&wcl, (WORD*)&hcl );
	CUA_InitRbutton( bigMulDiv( hcl, screen.sc_pheight, screen.sc_pwidth ),
			hcl );
	first_radio = FALSE;
    }
    return( annex );
}

/*--------------------------------------------------------------------------*/
MLOCAL	BYTE far	*init_toggle( TREE tree, short obj, BYTE far *annex )
{
    short    wch, hch, wcl, hcl;

    annex = (BYTE far *)init_progdef( tree, obj, (FAPPLBLK *)annex );
    
    if( first_toggle )
    {
	graf_handle( (WORD*)&wch, (WORD*)&hch, (WORD*)&wcl, (WORD*)&hcl );
	CUA_InitToggle( bigMulDiv( hcl, screen.sc_pheight, screen.sc_pwidth ),
			hcl );
	first_toggle = FALSE;
    }
    return( annex );
}
#endif /* CUA_BUTTONS */
/*--------------------------------------------------------------------------*/
/* NAME: fixup_rsc							    */
/*									    */
/* PURPOSE: This function does any special operation necessary before using */
/*	    an object in the resource, i.e. transforming icons, initializing*/
/*	    programm defined objects, initializing value boxes.		    */
/*									    */
/* INPUT:   TREE	tree	-   Current tree address.		    */
/*	    WORD	obj	-   Current object number.		    */
/*	    LONG	annex	-   Current address of next opening in the  */
/*				    annex buffer.			    */
/*									    */
/* OUTPUT:  LONG	return()-   New address of the next opening in the  */
/*				    annex buffer.			    */
/*--------------------------------------------------------------------------*/
    MLOCAL LONG
fixup_rsc(
    TREE	tree,
    WORD	obj,
    SLONG	annex )
{
    FDOBJECT	*obj_ptr;

    obj_ptr = tree + obj;
				/* are we at the root of a dialog tree? */
    if( obj == 0  &&  		/* is dialog colored correctly? */
	((((LONG)obj_ptr->ob_spec) & 0x0FFFFL) == 0x1141)  &&
	gl_nplanes >= 4 )	/* are we VGA color or better? */
    {
#if DIALOG3D
				/* thickness == 3, border color == 1 */
	((LONG)obj_ptr->ob_spec) = 0x00031000L + CC_BUTTON;
	obj_ptr->ob_flags |= USECOLORCAT + FLAG3D;
	obj_ptr->ob_state &= ~SHADOWED;
#else /* DIALOG3D */
				/* thickness == 2, border color == 1 */
	((LONG)obj_ptr->ob_spec) = 0x00021000L + CC_BUTTON;
	obj_ptr->ob_flags |= USECOLORCAT;
#endif /* DIALOG3D */
    }
    if( obj_ptr->ob_flags & HALFVSHIFT )
	obj_ptr->ob_box.y += screen.sc_mx_clhgt / 2 ;
    if( obj_ptr->ob_flags & HALFVSIZE )
	obj_ptr->ob_box.h += screen.sc_mx_clhgt / 2 ;
    
    switch( obj_ptr->ob_type )
    {
	case G_ICON:
	    trnfm_icon( (FDICONBLK *)obj_ptr->ob_spec );
	    break;
	case G_USERDEF:
	    annex = (LONG)init_progdef( tree, obj, (FAPPLBLK *)annex );
	    break;
	case VALUE_BOX:
	    annex = (LONG)init_value( tree, obj, (FVALUE *)annex );
	    break;
	case LIST_BOX:
	    annex = (LONG)init_listbox( tree, obj, (FLISTBOX *)annex );
	    break;
#if CUA_BUTTONS
	case TOGGLE_CUA_TYPE:
	    annex = (long)init_toggle( tree, obj, (BYTE far *)annex );
	    break;
	case RADIO_CUA_TYPE:
	    annex = (long)init_radio( tree, obj, (BYTE far *)annex );
	    break;
#endif /* CUA_BUTTONS */

	default:
#if HELP_ALERTS
	    if ( obj_ptr->ob_type == HELPBUTTON_TYPE )
		obj_ptr->ob_flags &= ~HIDETREE ;	
#endif /* HELP_ALERTS */
	    if( exobj_num( tree, obj ) >= 200 )
	    {
		annex = (LONG)init_progdef( tree, obj, (FAPPLBLK *)annex );
	    }
	    break;
	    
/* not used in ViewMAX : */
	case G_IMAGE:
	case G_TITLE:
	case G_STRING:
	case LIST_PHAM:
	case LIST_FILE:
	case SLIDER_BOX:
	case POP_UP:
	case PROGDEF_VDI:
	case COLOR_POPUP:
	    break ;
    }
    return( annex );
}
    
/*--------------------------------------------------------------------------*/
/* NAME: rsc_annex_size							    */
/*									    */
/* PURPOSE: This function calculates the amount of extra memory required    */
/*	    by the special complex objects in the resource.		    */
/*									    */
/* INPUT:   TREE	tree	-   Current tree address.		    */
/*	    WORD	obj	-   Current object number.		    */
/*	    LONG	size	-   Current size of annex.		    */
/*									    */
/* OUTPUT:  LONG	return()-   New size of annex.			    */
/*--------------------------------------------------------------------------*/
    MLOCAL LONG
rsc_annex_size(
    TREE	tree,
    WORD	obj,
    SLONG	size )
{
    FDOBJECT	*obj_ptr;
    
    obj_ptr = tree + obj;
    
    switch( obj_ptr->ob_type )
    {
	case G_USERDEF:
	    size += sizeof( APPLBLK );
	    break;
	case VALUE_BOX:
	    size += sizeof( VALUE );
	    break;
	case LIST_BOX:
	    size += sizeof( LISTBOX );
	    break;
	    
#if CUA_BUTTONS
	case TOGGLE_CUA_TYPE:
	    size += sizeof( APPLBLK );
	    break;
	case RADIO_CUA_TYPE:
	    size += sizeof( APPLBLK );
	    if( first_radio )
	    {
		size += 2 * Rbutton_size();
		first_radio = FALSE;
	    }
	    break;
#endif /* CUA_BUTTONS */

	default:
	    if( exobj_num( tree, obj ) >= 200 )
	    {
		size += sizeof( APPLBLK );
	    }
	    if( exobj_num( tree, obj ) == UNDERBAR_TEXT )
		size += sizeof( UNBARTXT ) ;
	    break;
	    
/* not used in ViewMAX : */	    
	case G_TITLE:
	case G_STRING:
	case LIST_PHAM:
	case LIST_FILE:
	case POP_UP:
	    break;
    }
    return( size );
}

/*--------------------------------------------------------------------------*/
/* NAME: walk_rsc							    */
/*									    */
/* PURPOSE: Walks the current resource and preforms the given function on   */
/*	    each object in the resource. The given function accepts the	    */
/*	    current tree address and object number and a long value as	    */
/*	    parameters.							    */
/*									    */
/* INPUT:   FRSHDR  * rshdr         -	Pointer to the resource header.     */
/*          LONG    (* action)()    -	Function to preform on each object. */
/*	    LONG    value	    -	Initial value of long passed into   */
/*					action.				    */
/*									    */
/* OUTPUT:  LONG    return()	    -	Final value returned from action.   */
/*--------------------------------------------------------------------------*/
    MLOCAL SLONG
walk_rsc(
    FRSHDR  *rshdr,
    LONG    (* action)( TREE tree, WORD obj, SLONG size ),
    SLONG    value )
{
    WORD	n_trees;
    TREE	tree;
    TREE	(far *tree_ptr);
    WORD	obj, prev_obj, head;
    FDOBJECT	*obj_ptr;
#if CUA_BUTTONS    
    first_radio = first_toggle = TRUE;
#endif /* CUA_BUTTONS */
    for( n_trees = rshdr->rsh_ntree - 1; n_trees >= 0; n_trees-- )
    {
	tree_ptr = (TREE far *)( (BYTE far *)rshdr + rshdr->rsh_trindex );
	tree = *( tree_ptr + n_trees);

        obj = 0;
        while( obj >= 0 )
        {
	    value = (* action)( tree, obj, value );
	    
            obj_ptr = tree + obj;
	    head = obj_ptr->ob_head;
            if( head > 0 )
            {
                obj = head;
            }
            else
            {
                prev_obj = obj;
		obj = obj_ptr->ob_next;
		obj_ptr = tree + obj;
		while( obj >= 0 && prev_obj == obj_ptr->ob_tail )
		{
		    prev_obj = obj;
		    obj = obj_ptr->ob_next;
		    obj_ptr = tree + obj;
		}
            }
        }
    }
    return( value );
}

/*--------------------------------------------------------------------------*/
/* NAME: trnfm_rsc							    */
/*									    */
/* PURPOSE: This function walks the resource twice. the first time it	    */
/*	    calculates any additional memory requirements needed by the	    */
/*	    resource. The second time it transforms icon and bit images	    */
/*	    and initializes the data structures for any complex objects	    */
/*	    in the resource.						    */
/*									    */
/* INPUT:   none							    */
/*									    */
/* OUTPUIT: void far *annex buffer for this resource file		    */
/*--------------------------------------------------------------------------*/

GLOBAL BYTE far *trnfm_rsc( void )
{
    SLONG	annex_size;		/* Size of resource annex.	    */
    
    annex_size = 0L;			/* Zero annex size.		    */
    annex_size = walk_rsc( global.ap_rsc, rsc_annex_size, annex_size ); 
    
    /* Allocate memory for annex.					    */
    if( dos_avail() < annex_size )
	return( (LONG)FALSE );
    
    annex_addr = (BYTE far *)dos_alloc( annex_size );
    if( DOS_ERR )
	return( (LONG)FALSE );
    
    walk_rsc( global.ap_rsc, fixup_rsc, (LONG)annex_addr ); 
					/* Fixup resource data.		    */
    
    trnfm_freeImage();			/* Transform free images.	    */
    
    return(annex_addr);
}

/* trnsrsc.c */
