/*	VALUEBOX.C		06/21/1988		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    	Copyright (c) 1988,1992 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/*
$Header: g:/groups/panther/dsk/rcs/valuebox.c 3.3 92/04/06 14:02:30 sbc Exp $
$Log:	valuebox.c $
 * Revision 3.3  92/04/06  14:02:30  sbc
 * remove include trnsrsc.h 
 * 
 * Revision 3.2  92/03/13  14:43:54  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * 911119 K.H	Optimized by DRJ. (#if JOPTIMIZE)
 * 910502 RSF	Prototype atoi. Can't include stdlib due to collision
 *		w/ our min/max.
 * 910426 RSF	Re-vamp vb_setMAX to use real step_sizes.
 * 910418 RSF	Add vb_setMAX and uncomment other needed routines.
 * 910405 RSF	LONG to SLONG
 * 910311 RSF	Adapted for use by ViewMAX.
 * 891128 rs added considering of hidden items in lb_scroll()
 * 900329 ts split off from EXOBINIT.C	
 */

#define	JOPTIMIZE	0

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "danutil.h"
#include "exproto.h"

/*--------------------------------------------------------------------------*/
/* NAME: vb_setMax							    */
/*									    */
/* PURPOSE: Change the maximum value for the slider, then recompute	    */
/*	    transformations.						    */
/*--------------------------------------------------------------------------*/
    VOID
vb_setMax( TREE	    tree,
	   WORD	    obj,
	   SLONG    val,
	   WORD	    redraw
	   )
{
    BYTE	buf[80];
    WORD	count;
    FVALUE	*vbdata;
    FDOBJECT	*val_ptr ;
    FTEDINFO	*te;
    FBYTE	*init_str;
    SLONG	step_size[11];
    
    vbdata = (FVALUE*)get_data_ptr( tree, obj );
    vbdata->vb_sld.sld_max = val;

    val_ptr = tree + find_exobj( tree,obj,VB_VALUE ); /* Find the value part*/
    val_ptr->ob_type = (val_ptr->ob_type & 0xFF00) | G_BOXTEXT;	/* Change to*/
    te = (FTEDINFO *)val_ptr->ob_spec;              /* G_BOXTEXT type.	    */
    init_str = (FBYTE *)te->te_pvalid;
    
					 /* Setup new slider transformation.*/
					 /* Skip over all but step sizes    */
    for (count=0; count<10; count++)
    {
	    init_str = get_field( buf, init_str );
	    if (!*init_str)
		    init_str++;
    }
			  
    for( count = 0; count < 10; count++ ) /* Setup nice step sizes.	    */
    {
	init_str = get_field( buf, init_str ); /* Get next stepsize.	    */
	step_size[count] = latoi( buf );
	if( !step_size[count] )
	    break;
    }
    step_size[10] = 0L;
    set_strans( (FSLIDER*)vbdata, step_size ); 
    snap_knob( (FSLIDER*)vbdata, redraw );
}

/*--------------------------------------------------------------------------*/
/* NAME: vb_setVal							    */
/*									    */
/* PURPOSE: External interfaces to set_val.				    */
/*--------------------------------------------------------------------------*/
    VOID
vb_setVal( TREE	    tree,
	   WORD	    obj,
	   SLONG	    val,
	   WORD	    redraw
	   )
{
    FBYTE   *vbdata;
    
    vbdata = get_data_ptr( tree, obj );
    set_val( vbdata, val, redraw );
    snap_knob( (FSLIDER*)vbdata, redraw );
}

/*--------------------------------------------------------------------------*/
/* NAME: get_value							    */
/*									    */
/* PURPOSE: To get the value and magnitude from a value box.		    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
get_value( TREE	    tree,		/* Address of the tree.		    */
	   WORD	    obj,		/* Number of value box parent.	    */
	   SLONG	    *val,		/* Address to return value.	    */
	   SLONG	    *mag		/* Address to return magnitude.	    */
	   )
{
    FVALUE	*vb;			/* Pointer to value box data.	    */
    WORD	exp;			/* Exponent from value format.	    */
    
    vb = (FVALUE *)get_data_ptr( tree, obj );
    *val = vb->vb_sld.sld_val;
    exp = (vb->vb_fmt & FMT_DPLACES) >> 8;
    *mag = power( 10L, exp );
}/*get_value*/

/*--------------------------------------------------------------------------*/
/* NAME: vb_parse							    */
/*									    */
/* PURPOSE: Parses the given value box data string and sets the value box   */
/*	    data accordingly.						    */
/*--------------------------------------------------------------------------*/
    GLOBAL VOID
vb_parse( FVALUE	*vb,		/* Value box data structure.	    */
	  FBYTE		*init_str	/* Value box data string.	    */
	  )
{
    BYTE	buf[80];
    SLONG	step_size[11];
    WORD	count;
    
    /* Get initialization information from validation string.		    */
    init_str = get_field( buf, init_str ); /* Format of value.		    */
    vb->vb_fmt = decode_format( buf );
    init_str = get_field( buf, init_str ); /* Initial value.		    */
    vb->vb_sld.sld_val = fmt_latoi( buf, vb->vb_fmt );
    init_str = get_field( buf, init_str ); /* Minimum value.		    */
    vb->vb_sld.sld_min = fmt_latoi( buf, vb->vb_fmt );
    init_str = get_field( buf, init_str ); /* Maximum value.		    */
    vb->vb_sld.sld_max = fmt_latoi( buf, vb->vb_fmt );
    init_str = get_field( buf, init_str ); /* Minor step size.		    */
    vb->vb_sld.sld_minor = fmt_latoi( buf, vb->vb_fmt );
    init_str = get_field( buf, init_str ); /* Major step size.		    */
    vb->vb_sld.sld_major = fmt_latoi( buf, vb->vb_fmt );
    vb->vb_before = init_str;		/* String before.		    */
    init_str = get_field( buf, init_str );
    if ( *init_str )
	*(init_str-1) = '\0';
    else
	init_str++ ;
    vb->vb_after = init_str;		/* String after.		    */
    init_str = get_field( buf, init_str );
    if ( *init_str )
	*(init_str-1) = '\0';
    else
	init_str++ ;
    init_str = get_field( buf, init_str ); /* Object to draw before update. */
    vb->vb_dobefore = atoi( buf );
    init_str = get_field( buf, init_str ); /* object to draw after update.  */
    vb->vb_doafter = atoi( buf );
    
    for( count = 0; count < 10; count++ ) /* Setup nice step sizes.	    */
    {
	init_str = get_field( buf, init_str ); /* Get next stepsize.	    */
	step_size[count] = latoi( buf );
	if( !step_size[count] )
	    break;
    }
    step_size[10] = 0L;
    set_strans( &vb->vb_sld, step_size ); /* Setup slider transformation.   */
    
}

#if JOPTIMIZE
/*--------------------------------------------------------------------------*/
/* NAME: vb_init							    */
/*									    */
/* PURPOSE: External interface to vb_parse.				    */
/*--------------------------------------------------------------------------*/
    VOID
vb_init( TREE	    tree,
	 WORD	    obj,
	 FBYTE	    *str
	 )
{
    FVALUE  *vb;
    
    vb = (FVALUE *)get_data_ptr( tree, obj );
    vb_parse( vb, str );
}

#endif /* JOPTIMIZE */

/* valuebox.c */
