;    File              : $Workfile: DATA.ASM$
;
;    Description       : GEM VDI language independent data
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    DATA.ASM 1.1 92/07/23 18:05:40 AWIGHTMA
;    Initial Conversion of GDOS from MWC/RASM86 - atw 23/7/92
;
;    ENDLOG

SUPPRESS_EXTERNALS	equ	1	; inhibit external data declarations
					; in the equates.inc file
include	equates.inc		; contains equates, definitions and externals

; Public data.
		public	app_buff
		public	app_buff_off
		public	app_buff_seg
		public	app_buff_size

		public	all_loaded
		public	aside_block
		public	assign_seg
if GEM
		public	best_double
		public	best_double_del
		public	best_double_off
		public	best_double_seg
		public	best_normal
		public	best_normal_del
		public	best_normal_off
		public	best_normal_seg
endif
		public	copy_contrl
		public	copy_intin
if GEM
		public	cur_absize
		public	cur_face
		public	cur_point
endif
		public	driver_count
		public	driver_head
		public	driver_off
		public	driver_seg
		public	driver_size
if GEM
		public	eff_size
endif
		public	entries
if GEM
		public	fb_free_off
		public	fb_free_seg
		public	fb_free_size
		public	fb_seg
		public	fb_size
		public	fhdr_count
endif
		public	file_count
		public	file_handle
if GEM
		public	first_font_seg
endif
		public	flip
if GEM
		public	font_block_seg
		public	font_count
		public	font_loaded
		public	font_val
		public	header_offset
		public	header_segment
		public	header_space
		public	incomplete_load
		public	last_font_off
		public	last_font_seg
endif
		public	load_successful
if GEM
		public	lruhi
		public	lrulo
		public	mfuhi
		public	mfulo
endif
		public	multi_id
		public	opcode
		public	pblock
if GEM
		public	phdr_count
		public	phdr_low
endif
		public	psp_base
		public	save_count
		public	save_end
		public	save_start
if GEM
		public	screen_font
		public	selmode
endif
		public	step_aside
if GEM
		public	str_handle
		public	str_index
endif
		public	text_buffer_size
if GEM
		public	this_font_off
		public	this_font_seg
endif
		public	work_identifier
		public	ws_absize
		public	ws_chead
		public	ws_coff
		public	ws_cseg
		public	ws_dseg
		public	ws_dsize
		public	ws_face
		public	ws_flags
		public	ws_font_block
		public	ws_font_seg
		public	ws_id
		public	ws_index
		public	ws_lruhi
		public	ws_lrulo
		public	ws_phdr_count
		public	ws_phdr_low
		public	ws_point
		public	ws_root
		public	ws_selmode
		public	ws_size
		public	ws_texbuf
		public	ws_texbuf_size
		public	ws_xform
		public	ws_xres
		public	ws_yres

		public	contrl
		public	driver_offset
if GEM
		public	fb_free_addr
		public	last_font_addr
		public	this_font_addr
endif
		public	intin
		public	intout
		public	ptsin
		public	ptsout
		public	save_contrl
		public	save_dta

		public	app_name
		public	aside_com_line
		public	aside_file
if GEM
		public	attr_val
		public	best_double_pts
		public	best_normal_pts
endif
		public	dyna_suppress
		public	font_path
if GEM
		public	font_suffix
endif
		public	gdos_drive
		public	gdos_dta
		public	gdos_path
if GEM
		public	info_file
		public	info_path
endif
		public	mouse_valid
		public	mouse_1
		public	mouse_2
		public	override
		public	pd_font
if GEM
		public	phdr_buf
endif
		public	rd_name
		public	resident_valid
		public	save_block
		public	save_tail_len
		public	saved_drive
		public	saved_path
		public	sb_end
		public	sd_font
		public	sd_name
if GEM
		public	str_buf
		public	str_suffix
endif
		public	overlay_segment
		public	prog_size
		public	assign_table_length
		public	overlay_segment
		public	ss_save
		public	sp_save
		public	root_path
		public	root_drive
		public	app_path
		public	command_tail


; Dynamic font loading suppression flag.
			db	'zyxg'
dyna_suppress		db	0		; default:  don't suppress

; Parameter block.
save_start		label word		; start of critical data
contrl			dd	0		; pointer to control array
intin			dd	0		; pointer to intin array
ptsin			dd	0		; pointer to ptsin array
intout			dd	0		; pointer to intout array
ptsout			dd	0		; pointer to ptsout array

; Other pointers.
save_contrl		dd	0		; pointer to original contrl
driver_offset		dd	0		; offset/segment of driver

; Parameter copy arrays.
copy_contrl		dw	12 dup (0)	; copy area for control array
copy_intin		dw	128 dup (0)	; copy area for intin array

; Workstation table.
ws_index		dw	0		; workstation table index
ws_id			dw	WS_ENTRIES dup (0)	; workstation identifier
ws_xres			dw	WS_ENTRIES dup (0)	; x resolution
ws_yres			dw	WS_ENTRIES dup (0)	; y resolution
ws_size			dw	WS_ENTRIES dup (0)	; size of driver
ws_coff			dw	WS_ENTRIES dup (0)	; starting offset of driver
ws_cseg			dw	WS_ENTRIES dup (0)	; starting segment of driver
ws_chead		dw	WS_ENTRIES dup (0)	; driver header location
ws_xform		dw	WS_ENTRIES dup (0)	; transformation mode
ws_flags		dw	WS_ENTRIES dup (0)	; flags:  resident, open
ws_dseg			dw	WS_ENTRIES dup (0)	; data segment address
ws_dsize		dw	WS_ENTRIES dup (0)	; data segment size
ws_root			dw	WS_ENTRIES dup (0)	; root handle
ws_font_seg		dw	WS_ENTRIES dup (0)	; first external font segment
ws_font_block		dw	WS_ENTRIES dup (0)	; lowest external font segment
ws_texbuf		dw	WS_ENTRIES dup (0)	; text buffer segment address
ws_texbuf_size		dw	WS_ENTRIES dup (0)	; text buffer size (bytes)
ws_phdr_low		dw	WS_ENTRIES dup (0)	; paged headers pointer
ws_phdr_count		dw	WS_ENTRIES dup (0)	; count of paged headers
ws_face			dw	WS_ENTRIES dup (0)	; current face
ws_point		dw	WS_ENTRIES dup (0)	; current point size
ws_absize		dw	WS_ENTRIES dup (0)	; current absolute size
ws_selmode		dw	WS_ENTRIES dup (0)	; current size selection mode
ws_lrulo		dw	WS_ENTRIES dup (0)	; header low LRU value
ws_lruhi		dw	WS_ENTRIES dup (0)	; header high LRU value

if GEM
; Font block processing variables.
fb_free_addr		label dword		; MUST BE ADJACENT TO NEXT TWO
fb_free_off		dw	0		; free block start offset
fb_free_seg		dw	0		; free block start segment
fb_free_size		dw	0		; font block free chain size
fb_seg			dw	0		; font block segment
fb_size			dw	0		; font block size
last_font_addr		label dword		; MUST BE ADJACENT TO NEXT TWO
last_font_off		dw	0		; last loaded header offset
last_font_seg		dw	0		; last loaded header segment
this_font_addr		label dword		; MUST BE ADJACENT TO NEXT TWO
this_font_off		dw	0		; current header offset
this_font_seg		dw	0		; current header segment
endif

; Other globals.
all_loaded		dw	0		; all fonts loaded flag
assign_seg		dw	0		; segment of assign table
driver_count		dw	0		; driver count in assign.sys
driver_head		dw	0		; driver header location
driver_off		dw	0		; driver starting offset
driver_seg		dw	0		; driver starting segment
driver_size		dw	0		; size of driver
file_handle		dw	0		; DOS 2.0 file handle
flip			dw	0		; flip y flag
if GEM
font_count		dw	0		; number of fonts left to load
font_loaded		dw	0		; flag:  did a font load?
endif
load_successful		dw	0		; successful driver load flag
opcode			dw	0		; current opcode
psp_base		dw	0		; segment address for GDOS PSP
text_buffer_size	dw	0		; size of dynamic text buffer
work_identifier		dw	0		; saved workstation identifier
save_end		label word		; end of critical data

; Limited re-entrancy support variables.
entries			dw	-1		; re-entrancy flag
save_count		dw	save_end - save_start	; save block size
save_block		label byte		; variable save block
sb_end			label byte
save_size		equ	save_end - save_start
data_size		equ	sb_end - save_block
			db	(save_size - data_size) dup (0)

; Step-aside support variables.
aside_block		dw	0		; environment string segment
			dd	aside_com_line	; command line
			dw	5ch		; first default FCB offset
			dw	0		; first default FCB segment
			dw	6ch		; second default FCB offset
			dw	0		; second default FCB segment
			db	5 dup (0)
aside_file		db	64 dup (0)	; prog to exec in step-aside
step_aside		dw	0		; full step-aside flag

; Temporaries:
file_count		dw	0
if GEM
header_offset		dw	0
header_segment		dw	0
header_space		dw	0
endif
multi_id		dw	0

; Disk environment.  Note that the step-aside command tail area and the
; saved path area share the same memory.
saved_drive		db	0		; storage for caller's drive
saved_path		db	'\'		; storage area for path
aside_com_line		db	80 dup (0)	; shared with step-aside

; The following two globals have to remain in the order given.
gdos_drive		db	0		; drive number for GDOS
gdos_path		db	'\'		; path for GDOS
			db	64 dup (0)

font_path		db	'..\fonts',0	; font file path relative to
			db	(64-9) dup (0)	;  GDOS directory

; Loader globals.
pblock		dw	0			; environment string segment
		dw	0			; command line offset
		dw	0			; command line segment
		dw	0			; first default FCB offset
		dw	0			; first default FCB segment
		dw	0			; second default FCB offset
		dw	0			; second default FCB segment
save_tail_len	db	0			; command tail size
app_name	db	'VIEWMAX.OVL',0,0,0,0,0,0	; application file name

; Command parameter validity globals.
mouse_valid	db	0			; mouse patch valid
resident_valid	db	0			; resident driver name valid

; Mouse patch globals.
mouse_1		db	0			; first mouse patch byte
mouse_2		db	0			; second mouse patch byte

; Screen driver and resident driver strings.
sd_name		db	'VIEWMAX.DRV'		; screen driver name
		db	0, 0, 0, 0, 0, 0, 0, 0
rd_name		db	13 dup (0)		; resident driver name
sd_font		db	'*.FNT', 0		; screen driver font name
pd_font		db	'*.FNT', 0		; printer driver font name

if GEM
; Font header file and string file information.
fhdr_count	dw	0			; count of headers
str_handle	dw	0			; string file handle
str_index	dw	0			; string file record index
font_suffix	db	'FHDR.INF', 0		; font header file suffix
str_suffix	db	'FSTR.INF', 0		; font string file suffix
info_file	db	66 dup (0)		; font file path
info_path	db	66 dup (0)		; information file path
str_buf		db	STR_BUFSIZ dup (0)	; string file data buffer

; Paged header information.
phdr_low	dw	0			; first paged header item
phdr_count	dw	0			; number of paged header items
phdr_buf	db	PGHD_LENGTH dup (0)	; paged header buffer

; Font management variables.
attr_val	dw	0			; current attribute value
best_double	dw	0			; size approximation global
best_double_del	dw	0			; size approximation global
best_double_off	dw	0			; size approximation global
best_double_seg	dw	0			; size approximation global
best_double_pts	db	0			; size approximation global
best_normal	dw	0			; size approximation global
best_normal_del	dw	0			; size approximation global
best_normal_off	dw	0			; size approximation global
best_normal_seg	dw	0			; size approximation global
best_normal_pts	db	0			; size approximation global
cur_absize	dw	0			; current absolute size
cur_face	dw	0			; current face
cur_point	dw	0			; current point size
selmode		dw	0			; size selection mode
font_block_seg	dw	0			; font block segment
font_val	dw	0			; current full font id
first_font_seg	dw	0			; first font segment
lrulo		dw	0			; header LRU value (low)
lruhi		dw	0			; header LRU value (high)
mfulo		dw	0			; MFU temporary (low)
mfuhi		dw	0			; MFU temporary (high)
screen_font	dw	0			; set to 1 for screen

; Miscellaneous font loading variables.
eff_size	dw	0			; effects buffer size (bytes)
incomplete_load	dw	0			; incomplete loading flag
endif

; DTA used by the GDOS and the location to save the current DTA in.
save_dta	dd	0			; saved DTA
gdos_dta	db	50 dup (0)		; GDOS DTA

app_buff	label dword
app_buff_off	dw	0		; GDOS extension app buffer offset
app_buff_seg	dw	0		; GDOS extension app buffer segment
app_buff_size	dw	0		; GDOS extension app buffer size

override	db	0FFh			; Screen driver override

;************************************************************************
;* Local data area for information which must be retained after loading.*
;************************************************************************

prog_size	dw	0
assign_table_length	dw	0
overlay_segment	dw	0
ss_save		dw	0
sp_save		dw	0
root_drive	db	0
root_path	db	'\', 0
		db	63 dup (0)
app_path	db	'\', 0
		db	63 dup (0)
command_tail	db	0, CR

CODE	ends
		end
