;    File              : $Workfile: DBCS.ASM$
;
;    Description       : double byte character support (from appslib)
;
;    Original Author   : Anthony Hay
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    DBCS.ASM 1.1 92/07/23 18:05:42 AWIGHTMA
;    ;	 9-Oct-89  ACH	Work began.
;    ;	29-Oct-91  K.H	Modified for GDOS.
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externals

if DBCS

; The Double Byte Character Set lead byte table.
; Each entry in the table except the last specifies a valid lead byte range.
;
;	+---------------+---------------+
;	|   number of bytes in table 	|
;	|	       (n)		|
;   0	+---------------+---------------+
;   	|    start of	|    end of 	|	DBCS table entry 0
;	|    range 0	|    range 0	|
;   2	+---------------+---------------+
;    	|    start of	|    end of 	|	DBCS table entry 1
;	|    range 1	|    range 1	|
;	+---------------+---------------+
;			:
;   n-2	+---------------+---------------+
;	|       0	|       0 	|	end of DBCS table
;	|    		|    		|
;	+---------------+---------------+


DBCS_LEN	equ	24		; maximum length of DBCS table
dbcs_table	dw   DBCS_LEN/2 dup (0)	; local copy of system DBCS table



	public	dbcs_init
	public	dbcs_expected
	public	dbcs_lead
	public	check_dbcs



DI_BUF_PTR	equ	dword ptr -4	; pointer to DBCS lead byte table
DI_BUF_ID	equ	byte ptr -5	; buffer id
DI_BUF		equ	byte ptr -5	; buffer

DI_LOCALS	equ	5		; No. bytes storage local to init_dbcs


dbcs_init:
;---------
; To initialise the double byte character set (DBCS) lead byte table.
; MUST be called before the first call to dbcs_lead() or dbcs_expected().
; Entry
;	none
; Exit
;	none (side effect: DBCS table initialised)


	push	bp
	mov	bp, sp
	sub	sp, DI_LOCALS		; allocate local variables
	push	ds
	push	es
	push	di
	push	si

	mov	cs:dbcs_table, 0	; assume DBCS table will be empty

	mov	ax, 06507h		; Extended Country Info: get DBCS ptr
	mov	bx, 0FFFFh		; codepage number: -1 for global cp
	mov	cx, 00005h		; size of info. buffer
	mov	dx, 0FFFFh		; country code: -1 for current country
	lea	di, DI_BUF[bp]
	push	ss
	pop	es			; es:di -> DI_BUF
	int	21h			; returns with DI_BUF filled in
	jc	di_exit			; just exit if function fails

	cmp	DI_BUF_ID[bp], 7	; is table for DBCS?
	jne	di_exit			;  no - exit
	push	cs
	pop	es
	mov	di, offset dbcs_table	; es:di -> local DBCS table
	lds	si, DI_BUF_PTR[bp]	; ds:si -> system DBCS table

	lodsw				; ax = number of bytes in table
	cmp	ax, DBCS_LEN		; more than we can manage?
	ja	di_exit			;  yes - exit (an "internal error!")
	mov	cx, ax			; cx = number of bytes to copy

	rep movsb			; copy table from system to local

di_exit:
	pop	si
	pop	di
	pop	es
	pop	ds
	mov	sp, bp
	pop	bp
	ret




dbcs_expected:
;-------------
; Returns true if double byte characters are to be expected.
; A call to dbcs_init() MUST have been made.
; Entry
;	none
; Exit
;	ax	= 1 - double byte characters are currently possible
;		  0 - double byte characters are not currently possible


	mov	ax, cs:dbcs_table	; ax = first entry in local DBCS table
	test 	ax, ax			; empty table?
	jz	de_exit			;  yes - return 0 (not expected)
	mov	ax, 1			; return 1 (yes you can expect DBCS)
de_exit:
	ret




dbcs_lead:
;---------
; Returns true if given byte is a valid lead byte of a 16 bit character.
; A call to init_dbcs() MUST have been made.
; Entry
;	2[bp]	= possible lead byte
; Exit
;	ax	= 1 - is a valid lead byte
;		  0 - is not a valid lead byte


	push	bp
	mov	bp, sp
	push	si
	push	ds
	push	bx

	mov	bx, 4[bp]		; bl = byte to be tested
	mov	ax, seg dbcs_table
	mov	ds, ax
	mov	si, offset dbcs_table	; ds:si -> local DBCS table

dl_loop:
	lodsw				; al/ah = start/end of range
	test 	ax, ax			; end of table?
	jz	dl_not_valid		;  yes - exit (not in table)
	cmp	al, bl			; start <= bl?
	ja	dl_loop			;  no - try next range
	cmp	ah, bl			; bl <= end?
	jb	dl_loop			;  no - try next range

	mov	ax, 1			; return 1 - valid lead byte
;;	jmp	dl_exit

dl_not_valid:
;;ax==0	sub	ax, ax			; return 0 - not valid lead byte

dl_exit:
	pop	bx
	pop	ds
	pop	si
	pop	bp
	ret




;****************************************************************
; check_dbcs							*
; Return whether a character in a string is a valid lead byte	*
; of the DBCS or not.
; Inputs:							*
;		DS:SI	pointer to the character to check	*
;		DX	starting offset of the string		*
; Returns:	AX	1:valid lead byte			*
;			0:not valid				*
;****************************************************************
check_dbcs:
	push	si
	push	cx
	xor	cx,cx
check_loop:
	cmp	dx, si
	jg	done_check
	std
	lodsb
	cld
	push	ax
	call	dbcs_lead
	add	sp, 2
	test	ax, ax
	jz	done_check
	inc	cl
	jmp short check_loop
done_check:
	mov	ax, cx
	and	ax, 1
	pop	cx
	pop	si
	ret

endif	;end of DBCS

CODE	ends
	end
